# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Incident(object):
    """
    Incident model.
    """

    #: A constant which can be used with the client_source property of a Incident.
    #: This constant has a value of "OCI_CONSOLE"
    CLIENT_SOURCE_OCI_CONSOLE = "OCI_CONSOLE"

    #: A constant which can be used with the client_source property of a Incident.
    #: This constant has a value of "ORACLE_MOS"
    CLIENT_SOURCE_ORACLE_MOS = "ORACLE_MOS"

    def __init__(self, **kwargs):
        """
        Initializes a new Incident object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this Incident.
        :type id: str

        :param reporter:
            The value to assign to the reporter property of this Incident.
        :type reporter: Reporter

        :param contact_list:
            The value to assign to the contact_list property of this Incident.
        :type contact_list: ContactList

        :param tenant:
            The value to assign to the tenant property of this Incident.
        :type tenant: Tenant

        :param ticket:
            The value to assign to the ticket property of this Incident.
        :type ticket: Ticket

        :param client_source:
            The value to assign to the client_source property of this Incident.
            Allowed values for this property are: "OCI_CONSOLE", "ORACLE_MOS", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type client_source: str

        :param incident_type:
            The value to assign to the incident_type property of this Incident.
        :type incident_type: IncidentType

        """
        self.swagger_types = {
            'id': 'str',
            'reporter': 'Reporter',
            'contact_list': 'ContactList',
            'tenant': 'Tenant',
            'ticket': 'Ticket',
            'client_source': 'str',
            'incident_type': 'IncidentType'
        }

        self.attribute_map = {
            'id': 'id',
            'reporter': 'reporter',
            'contact_list': 'contactList',
            'tenant': 'tenant',
            'ticket': 'ticket',
            'client_source': 'clientSource',
            'incident_type': 'incidentType'
        }

        self._id = None
        self._reporter = None
        self._contact_list = None
        self._tenant = None
        self._ticket = None
        self._client_source = None
        self._incident_type = None

    @property
    def id(self):
        """
        Gets the id of this Incident.

        :return: The id of this Incident.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Incident.

        :param id: The id of this Incident.
        :type: str
        """
        self._id = id

    @property
    def reporter(self):
        """
        Gets the reporter of this Incident.

        :return: The reporter of this Incident.
        :rtype: Reporter
        """
        return self._reporter

    @reporter.setter
    def reporter(self, reporter):
        """
        Sets the reporter of this Incident.

        :param reporter: The reporter of this Incident.
        :type: Reporter
        """
        self._reporter = reporter

    @property
    def contact_list(self):
        """
        Gets the contact_list of this Incident.

        :return: The contact_list of this Incident.
        :rtype: ContactList
        """
        return self._contact_list

    @contact_list.setter
    def contact_list(self, contact_list):
        """
        Sets the contact_list of this Incident.

        :param contact_list: The contact_list of this Incident.
        :type: ContactList
        """
        self._contact_list = contact_list

    @property
    def tenant(self):
        """
        Gets the tenant of this Incident.

        :return: The tenant of this Incident.
        :rtype: Tenant
        """
        return self._tenant

    @tenant.setter
    def tenant(self, tenant):
        """
        Sets the tenant of this Incident.

        :param tenant: The tenant of this Incident.
        :type: Tenant
        """
        self._tenant = tenant

    @property
    def ticket(self):
        """
        Gets the ticket of this Incident.

        :return: The ticket of this Incident.
        :rtype: Ticket
        """
        return self._ticket

    @ticket.setter
    def ticket(self, ticket):
        """
        Sets the ticket of this Incident.

        :param ticket: The ticket of this Incident.
        :type: Ticket
        """
        self._ticket = ticket

    @property
    def client_source(self):
        """
        Gets the client_source of this Incident.
        Allowed values for this property are: "OCI_CONSOLE", "ORACLE_MOS", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The client_source of this Incident.
        :rtype: str
        """
        return self._client_source

    @client_source.setter
    def client_source(self, client_source):
        """
        Sets the client_source of this Incident.

        :param client_source: The client_source of this Incident.
        :type: str
        """
        allowed_values = ["OCI_CONSOLE", "ORACLE_MOS"]
        if not value_allowed_none_or_none_sentinel(client_source, allowed_values):
            client_source = 'UNKNOWN_ENUM_VALUE'
        self._client_source = client_source

    @property
    def incident_type(self):
        """
        Gets the incident_type of this Incident.

        :return: The incident_type of this Incident.
        :rtype: IncidentType
        """
        return self._incident_type

    @incident_type.setter
    def incident_type(self, incident_type):
        """
        Sets the incident_type of this Incident.

        :param incident_type: The incident_type of this Incident.
        :type: IncidentType
        """
        self._incident_type = incident_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
