# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Item(object):
    """
    Item model.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new Item object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.cims.models.LimitItem`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this Item.
        :type id: str

        :param name:
            The value to assign to the name property of this Item.
        :type name: str

        :param type:
            The value to assign to the type property of this Item.
        :type type: str

        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'type': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'type': 'type'
        }

        self._id = None
        self._name = None
        self._type = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['type']

        if type == 'limit':
            return 'LimitItem'
        else:
            return 'Item'

    @property
    def id(self):
        """
        Gets the id of this Item.

        :return: The id of this Item.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Item.

        :param id: The id of this Item.
        :type: str
        """
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this Item.

        :return: The name of this Item.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this Item.

        :param name: The name of this Item.
        :type: str
        """
        self._name = name

    @property
    def type(self):
        """
        Gets the type of this Item.

        :return: The type of this Item.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this Item.

        :param type: The type of this Item.
        :type: str
        """
        self._type = type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
