# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.

from .item import Item
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class LimitItem(Item):
    """
    LimitItem model.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new LimitItem object with values from keyword arguments. The default value of the :py:attr:`~oci.cims.models.LimitItem.type` attribute
        of this class is ``limit`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this LimitItem.
        :type id: str

        :param name:
            The value to assign to the name property of this LimitItem.
        :type name: str

        :param type:
            The value to assign to the type property of this LimitItem.
        :type type: str

        :param current_limit:
            The value to assign to the current_limit property of this LimitItem.
        :type current_limit: int

        :param current_usage:
            The value to assign to the current_usage property of this LimitItem.
        :type current_usage: int

        :param requested_limit:
            The value to assign to the requested_limit property of this LimitItem.
        :type requested_limit: int

        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'type': 'str',
            'current_limit': 'int',
            'current_usage': 'int',
            'requested_limit': 'int'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'type': 'type',
            'current_limit': 'currentLimit',
            'current_usage': 'currentUsage',
            'requested_limit': 'requestedLimit'
        }

        self._id = None
        self._name = None
        self._type = None
        self._current_limit = None
        self._current_usage = None
        self._requested_limit = None
        self._type = 'limit'

    @property
    def current_limit(self):
        """
        Gets the current_limit of this LimitItem.

        :return: The current_limit of this LimitItem.
        :rtype: int
        """
        return self._current_limit

    @current_limit.setter
    def current_limit(self, current_limit):
        """
        Sets the current_limit of this LimitItem.

        :param current_limit: The current_limit of this LimitItem.
        :type: int
        """
        self._current_limit = current_limit

    @property
    def current_usage(self):
        """
        Gets the current_usage of this LimitItem.

        :return: The current_usage of this LimitItem.
        :rtype: int
        """
        return self._current_usage

    @current_usage.setter
    def current_usage(self, current_usage):
        """
        Sets the current_usage of this LimitItem.

        :param current_usage: The current_usage of this LimitItem.
        :type: int
        """
        self._current_usage = current_usage

    @property
    def requested_limit(self):
        """
        Gets the requested_limit of this LimitItem.

        :return: The requested_limit of this LimitItem.
        :rtype: int
        """
        return self._requested_limit

    @requested_limit.setter
    def requested_limit(self, requested_limit):
        """
        Sets the requested_limit of this LimitItem.

        :param requested_limit: The requested_limit of this LimitItem.
        :type: int
        """
        self._requested_limit = requested_limit

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
