# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PaginatedResponse(object):
    """
    PaginatedResponse model.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new PaginatedResponse object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param results:
            The value to assign to the results property of this PaginatedResponse.
        :type results: list[object]

        :param results_type:
            The value to assign to the results_type property of this PaginatedResponse.
        :type results_type: Type

        :param next:
            The value to assign to the next property of this PaginatedResponse.
        :type next: str

        :param prev:
            The value to assign to the prev property of this PaginatedResponse.
        :type prev: str

        """
        self.swagger_types = {
            'results': 'list[object]',
            'results_type': 'Type',
            'next': 'str',
            'prev': 'str'
        }

        self.attribute_map = {
            'results': 'results',
            'results_type': 'resultsType',
            'next': 'next',
            'prev': 'prev'
        }

        self._results = None
        self._results_type = None
        self._next = None
        self._prev = None

    @property
    def results(self):
        """
        Gets the results of this PaginatedResponse.

        :return: The results of this PaginatedResponse.
        :rtype: list[object]
        """
        return self._results

    @results.setter
    def results(self, results):
        """
        Sets the results of this PaginatedResponse.

        :param results: The results of this PaginatedResponse.
        :type: list[object]
        """
        self._results = results

    @property
    def results_type(self):
        """
        Gets the results_type of this PaginatedResponse.

        :return: The results_type of this PaginatedResponse.
        :rtype: Type
        """
        return self._results_type

    @results_type.setter
    def results_type(self, results_type):
        """
        Sets the results_type of this PaginatedResponse.

        :param results_type: The results_type of this PaginatedResponse.
        :type: Type
        """
        self._results_type = results_type

    @property
    def next(self):
        """
        Gets the next of this PaginatedResponse.

        :return: The next of this PaginatedResponse.
        :rtype: str
        """
        return self._next

    @next.setter
    def next(self, next):
        """
        Sets the next of this PaginatedResponse.

        :param next: The next of this PaginatedResponse.
        :type: str
        """
        self._next = next

    @property
    def prev(self):
        """
        Gets the prev of this PaginatedResponse.

        :return: The prev of this PaginatedResponse.
        :rtype: str
        """
        return self._prev

    @prev.setter
    def prev(self, prev):
        """
        Sets the prev of this PaginatedResponse.

        :param prev: The prev of this PaginatedResponse.
        :type: str
        """
        self._prev = prev

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
