# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PaginatedResponseIncident(object):
    """
    PaginatedResponseIncident model.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new PaginatedResponseIncident object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param results:
            The value to assign to the results property of this PaginatedResponseIncident.
        :type results: list[Incident]

        :param results_type:
            The value to assign to the results_type property of this PaginatedResponseIncident.
        :type results_type: Type

        :param next:
            The value to assign to the next property of this PaginatedResponseIncident.
        :type next: str

        :param prev:
            The value to assign to the prev property of this PaginatedResponseIncident.
        :type prev: str

        """
        self.swagger_types = {
            'results': 'list[Incident]',
            'results_type': 'Type',
            'next': 'str',
            'prev': 'str'
        }

        self.attribute_map = {
            'results': 'results',
            'results_type': 'resultsType',
            'next': 'next',
            'prev': 'prev'
        }

        self._results = None
        self._results_type = None
        self._next = None
        self._prev = None

    @property
    def results(self):
        """
        Gets the results of this PaginatedResponseIncident.

        :return: The results of this PaginatedResponseIncident.
        :rtype: list[Incident]
        """
        return self._results

    @results.setter
    def results(self, results):
        """
        Sets the results of this PaginatedResponseIncident.

        :param results: The results of this PaginatedResponseIncident.
        :type: list[Incident]
        """
        self._results = results

    @property
    def results_type(self):
        """
        Gets the results_type of this PaginatedResponseIncident.

        :return: The results_type of this PaginatedResponseIncident.
        :rtype: Type
        """
        return self._results_type

    @results_type.setter
    def results_type(self, results_type):
        """
        Sets the results_type of this PaginatedResponseIncident.

        :param results_type: The results_type of this PaginatedResponseIncident.
        :type: Type
        """
        self._results_type = results_type

    @property
    def next(self):
        """
        Gets the next of this PaginatedResponseIncident.

        :return: The next of this PaginatedResponseIncident.
        :rtype: str
        """
        return self._next

    @next.setter
    def next(self, next):
        """
        Sets the next of this PaginatedResponseIncident.

        :param next: The next of this PaginatedResponseIncident.
        :type: str
        """
        self._next = next

    @property
    def prev(self):
        """
        Gets the prev of this PaginatedResponseIncident.

        :return: The prev of this PaginatedResponseIncident.
        :rtype: str
        """
        return self._prev

    @prev.setter
    def prev(self, prev):
        """
        Sets the prev of this PaginatedResponseIncident.

        :param prev: The prev of this PaginatedResponseIncident.
        :type: str
        """
        self._prev = prev

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
