# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Reporter(object):
    """
    Reporter model.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new Reporter object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param user_id:
            The value to assign to the user_id property of this Reporter.
        :type user_id: str

        :param email:
            The value to assign to the email property of this Reporter.
        :type email: str

        """
        self.swagger_types = {
            'user_id': 'str',
            'email': 'str'
        }

        self.attribute_map = {
            'user_id': 'userId',
            'email': 'email'
        }

        self._user_id = None
        self._email = None

    @property
    def user_id(self):
        """
        **[Required]** Gets the user_id of this Reporter.

        :return: The user_id of this Reporter.
        :rtype: str
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id):
        """
        Sets the user_id of this Reporter.

        :param user_id: The user_id of this Reporter.
        :type: str
        """
        self._user_id = user_id

    @property
    def email(self):
        """
        Gets the email of this Reporter.

        :return: The email of this Reporter.
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """
        Sets the email of this Reporter.

        :param email: The email of this Reporter.
        :type: str
        """
        self._email = email

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
