# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Tenant(object):
    """
    Customer Tenant
    """

    def __init__(self, **kwargs):
        """
        Initializes a new Tenant object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param customer_support_identifier:
            The value to assign to the customer_support_identifier property of this Tenant.
        :type customer_support_identifier: str

        :param tenant_id:
            The value to assign to the tenant_id property of this Tenant.
        :type tenant_id: str

        """
        self.swagger_types = {
            'customer_support_identifier': 'str',
            'tenant_id': 'str'
        }

        self.attribute_map = {
            'customer_support_identifier': 'customerSupportIdentifier',
            'tenant_id': 'tenantId'
        }

        self._customer_support_identifier = None
        self._tenant_id = None

    @property
    def customer_support_identifier(self):
        """
        **[Required]** Gets the customer_support_identifier of this Tenant.

        :return: The customer_support_identifier of this Tenant.
        :rtype: str
        """
        return self._customer_support_identifier

    @customer_support_identifier.setter
    def customer_support_identifier(self, customer_support_identifier):
        """
        Sets the customer_support_identifier of this Tenant.

        :param customer_support_identifier: The customer_support_identifier of this Tenant.
        :type: str
        """
        self._customer_support_identifier = customer_support_identifier

    @property
    def tenant_id(self):
        """
        **[Required]** Gets the tenant_id of this Tenant.

        :return: The tenant_id of this Tenant.
        :rtype: str
        """
        return self._tenant_id

    @tenant_id.setter
    def tenant_id(self, tenant_id):
        """
        Sets the tenant_id of this Tenant.

        :param tenant_id: The tenant_id of this Tenant.
        :type: str
        """
        self._tenant_id = tenant_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
