# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Ticket(object):
    """
    Ticket class
    """

    #: A constant which can be used with the severity property of a Ticket.
    #: This constant has a value of "HIGHEST"
    SEVERITY_HIGHEST = "HIGHEST"

    #: A constant which can be used with the severity property of a Ticket.
    #: This constant has a value of "HIGH"
    SEVERITY_HIGH = "HIGH"

    #: A constant which can be used with the severity property of a Ticket.
    #: This constant has a value of "MEDIUM"
    SEVERITY_MEDIUM = "MEDIUM"

    #: A constant which can be used with the severity property of a Ticket.
    #: This constant has a value of "LOW"
    SEVERITY_LOW = "LOW"

    #: A constant which can be used with the severity property of a Ticket.
    #: This constant has a value of "LOWEST"
    SEVERITY_LOWEST = "LOWEST"

    def __init__(self, **kwargs):
        """
        Initializes a new Ticket object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this Ticket.
        :type id: str

        :param severity:
            The value to assign to the severity property of this Ticket.
            Allowed values for this property are: "HIGHEST", "HIGH", "MEDIUM", "LOW", "LOWEST", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type severity: str

        :param resource_list:
            The value to assign to the resource_list property of this Ticket.
        :type resource_list: list[Resource]

        :param title:
            The value to assign to the title property of this Ticket.
        :type title: str

        :param description:
            The value to assign to the description property of this Ticket.
        :type description: str

        :param time_created:
            The value to assign to the time_created property of this Ticket.
        :type time_created: int

        :param time_updated:
            The value to assign to the time_updated property of this Ticket.
        :type time_updated: int

        :param status:
            The value to assign to the status property of this Ticket.
        :type status: Status

        """
        self.swagger_types = {
            'id': 'str',
            'severity': 'str',
            'resource_list': 'list[Resource]',
            'title': 'str',
            'description': 'str',
            'time_created': 'int',
            'time_updated': 'int',
            'status': 'Status'
        }

        self.attribute_map = {
            'id': 'id',
            'severity': 'severity',
            'resource_list': 'resourceList',
            'title': 'title',
            'description': 'description',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'status': 'status'
        }

        self._id = None
        self._severity = None
        self._resource_list = None
        self._title = None
        self._description = None
        self._time_created = None
        self._time_updated = None
        self._status = None

    @property
    def id(self):
        """
        Gets the id of this Ticket.

        :return: The id of this Ticket.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Ticket.

        :param id: The id of this Ticket.
        :type: str
        """
        self._id = id

    @property
    def severity(self):
        """
        Gets the severity of this Ticket.
        Allowed values for this property are: "HIGHEST", "HIGH", "MEDIUM", "LOW", "LOWEST", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The severity of this Ticket.
        :rtype: str
        """
        return self._severity

    @severity.setter
    def severity(self, severity):
        """
        Sets the severity of this Ticket.

        :param severity: The severity of this Ticket.
        :type: str
        """
        allowed_values = ["HIGHEST", "HIGH", "MEDIUM", "LOW", "LOWEST"]
        if not value_allowed_none_or_none_sentinel(severity, allowed_values):
            severity = 'UNKNOWN_ENUM_VALUE'
        self._severity = severity

    @property
    def resource_list(self):
        """
        Gets the resource_list of this Ticket.

        :return: The resource_list of this Ticket.
        :rtype: list[Resource]
        """
        return self._resource_list

    @resource_list.setter
    def resource_list(self, resource_list):
        """
        Sets the resource_list of this Ticket.

        :param resource_list: The resource_list of this Ticket.
        :type: list[Resource]
        """
        self._resource_list = resource_list

    @property
    def title(self):
        """
        **[Required]** Gets the title of this Ticket.

        :return: The title of this Ticket.
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """
        Sets the title of this Ticket.

        :param title: The title of this Ticket.
        :type: str
        """
        self._title = title

    @property
    def description(self):
        """
        **[Required]** Gets the description of this Ticket.

        :return: The description of this Ticket.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this Ticket.

        :param description: The description of this Ticket.
        :type: str
        """
        self._description = description

    @property
    def time_created(self):
        """
        Gets the time_created of this Ticket.

        :return: The time_created of this Ticket.
        :rtype: int
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this Ticket.

        :param time_created: The time_created of this Ticket.
        :type: int
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this Ticket.

        :return: The time_updated of this Ticket.
        :rtype: int
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this Ticket.

        :param time_updated: The time_updated of this Ticket.
        :type: int
        """
        self._time_updated = time_updated

    @property
    def status(self):
        """
        Gets the status of this Ticket.

        :return: The status of this Ticket.
        :rtype: Status
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this Ticket.

        :param status: The status of this Ticket.
        :type: Status
        """
        self._status = status

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
