# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Type(object):
    """
    Type model.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new Type object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type_name:
            The value to assign to the type_name property of this Type.
        :type type_name: str

        """
        self.swagger_types = {
            'type_name': 'str'
        }

        self.attribute_map = {
            'type_name': 'typeName'
        }

        self._type_name = None

    @property
    def type_name(self):
        """
        Gets the type_name of this Type.

        :return: The type_name of this Type.
        :rtype: str
        """
        return self._type_name

    @type_name.setter
    def type_name(self, type_name):
        """
        Sets the type_name of this Type.

        :param type_name: The type_name of this Type.
        :type: str
        """
        self._type_name = type_name

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
