# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AcceptLocalPeeringTokenDetails(object):
    """
    Contains a peering token generated by a peer. By accepting a peering token, you are facilitating a peering handshake. Once both sides accept peering tokens, a peering is established.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AcceptLocalPeeringTokenDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param token_from_peer:
            The value to assign to the token_from_peer property of this AcceptLocalPeeringTokenDetails.
        :type token_from_peer: str

        """
        self.swagger_types = {
            'token_from_peer': 'str'
        }

        self.attribute_map = {
            'token_from_peer': 'tokenFromPeer'
        }

        self._token_from_peer = None

    @property
    def token_from_peer(self):
        """
        **[Required]** Gets the token_from_peer of this AcceptLocalPeeringTokenDetails.
        An opaque token obtained from a peer.


        :return: The token_from_peer of this AcceptLocalPeeringTokenDetails.
        :rtype: str
        """
        return self._token_from_peer

    @token_from_peer.setter
    def token_from_peer(self, token_from_peer):
        """
        Sets the token_from_peer of this AcceptLocalPeeringTokenDetails.
        An opaque token obtained from a peer.


        :param token_from_peer: The token_from_peer of this AcceptLocalPeeringTokenDetails.
        :type: str
        """
        self._token_from_peer = token_from_peer

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
