# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ConnectLocalPeeringConnectionsDetails(object):
    """
    Contains details indicating the local peering connection with which you wish to establish a peering relationship.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ConnectLocalPeeringConnectionsDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param peer_id:
            The value to assign to the peer_id property of this ConnectLocalPeeringConnectionsDetails.
        :type peer_id: str

        """
        self.swagger_types = {
            'peer_id': 'str'
        }

        self.attribute_map = {
            'peer_id': 'peerId'
        }

        self._peer_id = None

    @property
    def peer_id(self):
        """
        **[Required]** Gets the peer_id of this ConnectLocalPeeringConnectionsDetails.
        The OCID of the other local peering connection.


        :return: The peer_id of this ConnectLocalPeeringConnectionsDetails.
        :rtype: str
        """
        return self._peer_id

    @peer_id.setter
    def peer_id(self, peer_id):
        """
        Sets the peer_id of this ConnectLocalPeeringConnectionsDetails.
        The OCID of the other local peering connection.


        :param peer_id: The peer_id of this ConnectLocalPeeringConnectionsDetails.
        :type: str
        """
        self._peer_id = peer_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
