# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateEndpointServiceDetails(object):
    """
    Details for creating an endpoint service.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateEndpointServiceDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param vcn_id:
            The value to assign to the vcn_id property of this CreateEndpointServiceDetails.
        :type vcn_id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateEndpointServiceDetails.
        :type compartment_id: str

        :param description:
            The value to assign to the description property of this CreateEndpointServiceDetails.
        :type description: str

        :param display_name:
            The value to assign to the display_name property of this CreateEndpointServiceDetails.
        :type display_name: str

        :param are_multiple_private_endpoints_per_vcn_allowed:
            The value to assign to the are_multiple_private_endpoints_per_vcn_allowed property of this CreateEndpointServiceDetails.
        :type are_multiple_private_endpoints_per_vcn_allowed: bool

        :param is_vcn_metadata_enabled:
            The value to assign to the is_vcn_metadata_enabled property of this CreateEndpointServiceDetails.
        :type is_vcn_metadata_enabled: bool

        :param service_ips:
            The value to assign to the service_ips property of this CreateEndpointServiceDetails.
        :type service_ips: list[EndpointServiceIpDetails]

        :param ports:
            The value to assign to the ports property of this CreateEndpointServiceDetails.
        :type ports: list[int]

        :param endpoint_fqdn:
            The value to assign to the endpoint_fqdn property of this CreateEndpointServiceDetails.
        :type endpoint_fqdn: str

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateEndpointServiceDetails.
        :type defined_tags: dict(str, dict(str, object))

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateEndpointServiceDetails.
        :type freeform_tags: dict(str, str)

        """
        self.swagger_types = {
            'vcn_id': 'str',
            'compartment_id': 'str',
            'description': 'str',
            'display_name': 'str',
            'are_multiple_private_endpoints_per_vcn_allowed': 'bool',
            'is_vcn_metadata_enabled': 'bool',
            'service_ips': 'list[EndpointServiceIpDetails]',
            'ports': 'list[int]',
            'endpoint_fqdn': 'str',
            'defined_tags': 'dict(str, dict(str, object))',
            'freeform_tags': 'dict(str, str)'
        }

        self.attribute_map = {
            'vcn_id': 'vcnId',
            'compartment_id': 'compartmentId',
            'description': 'description',
            'display_name': 'displayName',
            'are_multiple_private_endpoints_per_vcn_allowed': 'areMultiplePrivateEndpointsPerVcnAllowed',
            'is_vcn_metadata_enabled': 'isVcnMetadataEnabled',
            'service_ips': 'serviceIps',
            'ports': 'ports',
            'endpoint_fqdn': 'endpointFqdn',
            'defined_tags': 'definedTags',
            'freeform_tags': 'freeformTags'
        }

        self._vcn_id = None
        self._compartment_id = None
        self._description = None
        self._display_name = None
        self._are_multiple_private_endpoints_per_vcn_allowed = None
        self._is_vcn_metadata_enabled = None
        self._service_ips = None
        self._ports = None
        self._endpoint_fqdn = None
        self._defined_tags = None
        self._freeform_tags = None

    @property
    def vcn_id(self):
        """
        **[Required]** Gets the vcn_id of this CreateEndpointServiceDetails.
        The `OCID`__ of the service VCN that the endpoint
        service belongs to.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The vcn_id of this CreateEndpointServiceDetails.
        :rtype: str
        """
        return self._vcn_id

    @vcn_id.setter
    def vcn_id(self, vcn_id):
        """
        Sets the vcn_id of this CreateEndpointServiceDetails.
        The `OCID`__ of the service VCN that the endpoint
        service belongs to.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param vcn_id: The vcn_id of this CreateEndpointServiceDetails.
        :type: str
        """
        self._vcn_id = vcn_id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateEndpointServiceDetails.
        The `OCID`__ of the compartment to contain the
        endpoint service.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this CreateEndpointServiceDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateEndpointServiceDetails.
        The `OCID`__ of the compartment to contain the
        endpoint service.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this CreateEndpointServiceDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def description(self):
        """
        Gets the description of this CreateEndpointServiceDetails.
        A description of the endpoint service. For Oracle services that use the \"trusted\" mode of the private endpoint service, customers never see this description. Avoid entering confidential information.


        :return: The description of this CreateEndpointServiceDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CreateEndpointServiceDetails.
        A description of the endpoint service. For Oracle services that use the \"trusted\" mode of the private endpoint service, customers never see this description. Avoid entering confidential information.


        :param description: The description of this CreateEndpointServiceDetails.
        :type: str
        """
        self._description = description

    @property
    def display_name(self):
        """
        Gets the display_name of this CreateEndpointServiceDetails.
        A friendly name for the endpoint service. Must be unique within the VCN.


        :return: The display_name of this CreateEndpointServiceDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateEndpointServiceDetails.
        A friendly name for the endpoint service. Must be unique within the VCN.


        :param display_name: The display_name of this CreateEndpointServiceDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def are_multiple_private_endpoints_per_vcn_allowed(self):
        """
        Gets the are_multiple_private_endpoints_per_vcn_allowed of this CreateEndpointServiceDetails.
        Some services want to restrict access to the resources represented by an endpoint service so
        that only a single private endpoint in the customer VCN has access.

        For example, the endpoint service might represent a particular service resource (such as a
        particular database). The service might want to allow access to that particular resource
        from only a single private endpoint.

        Defaults to `false`.

        **Note:** If the value is `true`, the `endpointFqdn` attribute cannot have a value. For more
        information, see the discussion of DNS and FQDNs in
        :class:`PrivateEndpoint`.

        Example: `true`


        :return: The are_multiple_private_endpoints_per_vcn_allowed of this CreateEndpointServiceDetails.
        :rtype: bool
        """
        return self._are_multiple_private_endpoints_per_vcn_allowed

    @are_multiple_private_endpoints_per_vcn_allowed.setter
    def are_multiple_private_endpoints_per_vcn_allowed(self, are_multiple_private_endpoints_per_vcn_allowed):
        """
        Sets the are_multiple_private_endpoints_per_vcn_allowed of this CreateEndpointServiceDetails.
        Some services want to restrict access to the resources represented by an endpoint service so
        that only a single private endpoint in the customer VCN has access.

        For example, the endpoint service might represent a particular service resource (such as a
        particular database). The service might want to allow access to that particular resource
        from only a single private endpoint.

        Defaults to `false`.

        **Note:** If the value is `true`, the `endpointFqdn` attribute cannot have a value. For more
        information, see the discussion of DNS and FQDNs in
        :class:`PrivateEndpoint`.

        Example: `true`


        :param are_multiple_private_endpoints_per_vcn_allowed: The are_multiple_private_endpoints_per_vcn_allowed of this CreateEndpointServiceDetails.
        :type: bool
        """
        self._are_multiple_private_endpoints_per_vcn_allowed = are_multiple_private_endpoints_per_vcn_allowed

    @property
    def is_vcn_metadata_enabled(self):
        """
        Gets the is_vcn_metadata_enabled of this CreateEndpointServiceDetails.
        Reserved for future use.


        :return: The is_vcn_metadata_enabled of this CreateEndpointServiceDetails.
        :rtype: bool
        """
        return self._is_vcn_metadata_enabled

    @is_vcn_metadata_enabled.setter
    def is_vcn_metadata_enabled(self, is_vcn_metadata_enabled):
        """
        Sets the is_vcn_metadata_enabled of this CreateEndpointServiceDetails.
        Reserved for future use.


        :param is_vcn_metadata_enabled: The is_vcn_metadata_enabled of this CreateEndpointServiceDetails.
        :type: bool
        """
        self._is_vcn_metadata_enabled = is_vcn_metadata_enabled

    @property
    def service_ips(self):
        """
        **[Required]** Gets the service_ips of this CreateEndpointServiceDetails.
        List of service IP addresses (in the service VCN) that handle requests to the endpoint service.


        :return: The service_ips of this CreateEndpointServiceDetails.
        :rtype: list[EndpointServiceIpDetails]
        """
        return self._service_ips

    @service_ips.setter
    def service_ips(self, service_ips):
        """
        Sets the service_ips of this CreateEndpointServiceDetails.
        List of service IP addresses (in the service VCN) that handle requests to the endpoint service.


        :param service_ips: The service_ips of this CreateEndpointServiceDetails.
        :type: list[EndpointServiceIpDetails]
        """
        self._service_ips = service_ips

    @property
    def ports(self):
        """
        Gets the ports of this CreateEndpointServiceDetails.
        The ports on the endpoint service IPs that are open for private endpoint traffic for this
        endpoint service. If you provide no ports, all open ports on the service IPs are accessible.


        :return: The ports of this CreateEndpointServiceDetails.
        :rtype: list[int]
        """
        return self._ports

    @ports.setter
    def ports(self, ports):
        """
        Sets the ports of this CreateEndpointServiceDetails.
        The ports on the endpoint service IPs that are open for private endpoint traffic for this
        endpoint service. If you provide no ports, all open ports on the service IPs are accessible.


        :param ports: The ports of this CreateEndpointServiceDetails.
        :type: list[int]
        """
        self._ports = ports

    @property
    def endpoint_fqdn(self):
        """
        Gets the endpoint_fqdn of this CreateEndpointServiceDetails.
        The default three-label FQDN to use for all private endpoints associated with this endpoint
        service. For important information about how this attribute is used, see the discussion of DNS
        and FQDNs in :class:`PrivateEndpoint`.

        If `areMultiplePrivateEndpointsPerVcnAllowed` is `true`, `endpointFqdn` cannot have a value.

        Example: `xyz.oraclecloud.com`


        :return: The endpoint_fqdn of this CreateEndpointServiceDetails.
        :rtype: str
        """
        return self._endpoint_fqdn

    @endpoint_fqdn.setter
    def endpoint_fqdn(self, endpoint_fqdn):
        """
        Sets the endpoint_fqdn of this CreateEndpointServiceDetails.
        The default three-label FQDN to use for all private endpoints associated with this endpoint
        service. For important information about how this attribute is used, see the discussion of DNS
        and FQDNs in :class:`PrivateEndpoint`.

        If `areMultiplePrivateEndpointsPerVcnAllowed` is `true`, `endpointFqdn` cannot have a value.

        Example: `xyz.oraclecloud.com`


        :param endpoint_fqdn: The endpoint_fqdn of this CreateEndpointServiceDetails.
        :type: str
        """
        self._endpoint_fqdn = endpoint_fqdn

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateEndpointServiceDetails.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CreateEndpointServiceDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateEndpointServiceDetails.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CreateEndpointServiceDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateEndpointServiceDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CreateEndpointServiceDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateEndpointServiceDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CreateEndpointServiceDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
