# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateFlowLogConfigAttachmentDetails(object):
    """
    CreateFlowLogConfigAttachmentDetails model.
    """

    #: A constant which can be used with the target_entity_type property of a CreateFlowLogConfigAttachmentDetails.
    #: This constant has a value of "SUBNET"
    TARGET_ENTITY_TYPE_SUBNET = "SUBNET"

    def __init__(self, **kwargs):
        """
        Initializes a new CreateFlowLogConfigAttachmentDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this CreateFlowLogConfigAttachmentDetails.
        :type display_name: str

        :param target_entity_id:
            The value to assign to the target_entity_id property of this CreateFlowLogConfigAttachmentDetails.
        :type target_entity_id: str

        :param target_entity_type:
            The value to assign to the target_entity_type property of this CreateFlowLogConfigAttachmentDetails.
            Allowed values for this property are: "SUBNET"
        :type target_entity_type: str

        :param flow_log_config_id:
            The value to assign to the flow_log_config_id property of this CreateFlowLogConfigAttachmentDetails.
        :type flow_log_config_id: str

        """
        self.swagger_types = {
            'display_name': 'str',
            'target_entity_id': 'str',
            'target_entity_type': 'str',
            'flow_log_config_id': 'str'
        }

        self.attribute_map = {
            'display_name': 'displayName',
            'target_entity_id': 'targetEntityId',
            'target_entity_type': 'targetEntityType',
            'flow_log_config_id': 'flowLogConfigId'
        }

        self._display_name = None
        self._target_entity_id = None
        self._target_entity_type = None
        self._flow_log_config_id = None

    @property
    def display_name(self):
        """
        Gets the display_name of this CreateFlowLogConfigAttachmentDetails.
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid
        entering confidential information.


        :return: The display_name of this CreateFlowLogConfigAttachmentDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateFlowLogConfigAttachmentDetails.
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid
        entering confidential information.


        :param display_name: The display_name of this CreateFlowLogConfigAttachmentDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def target_entity_id(self):
        """
        **[Required]** Gets the target_entity_id of this CreateFlowLogConfigAttachmentDetails.
        The `OCID`__ of the resource to attach the
        flow log configuration to. Attaching the configuration enables flow logs for the resource.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The target_entity_id of this CreateFlowLogConfigAttachmentDetails.
        :rtype: str
        """
        return self._target_entity_id

    @target_entity_id.setter
    def target_entity_id(self, target_entity_id):
        """
        Sets the target_entity_id of this CreateFlowLogConfigAttachmentDetails.
        The `OCID`__ of the resource to attach the
        flow log configuration to. Attaching the configuration enables flow logs for the resource.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param target_entity_id: The target_entity_id of this CreateFlowLogConfigAttachmentDetails.
        :type: str
        """
        self._target_entity_id = target_entity_id

    @property
    def target_entity_type(self):
        """
        **[Required]** Gets the target_entity_type of this CreateFlowLogConfigAttachmentDetails.
        The type of resource to attach the flow log configuration to.

        Allowed values for this property are: "SUBNET"


        :return: The target_entity_type of this CreateFlowLogConfigAttachmentDetails.
        :rtype: str
        """
        return self._target_entity_type

    @target_entity_type.setter
    def target_entity_type(self, target_entity_type):
        """
        Sets the target_entity_type of this CreateFlowLogConfigAttachmentDetails.
        The type of resource to attach the flow log configuration to.


        :param target_entity_type: The target_entity_type of this CreateFlowLogConfigAttachmentDetails.
        :type: str
        """
        allowed_values = ["SUBNET"]
        if not value_allowed_none_or_none_sentinel(target_entity_type, allowed_values):
            raise ValueError(
                "Invalid value for `target_entity_type`, must be None or one of {0}"
                .format(allowed_values)
            )
        self._target_entity_type = target_entity_type

    @property
    def flow_log_config_id(self):
        """
        **[Required]** Gets the flow_log_config_id of this CreateFlowLogConfigAttachmentDetails.
        The `OCID`__ of the flow log configuration to attach.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The flow_log_config_id of this CreateFlowLogConfigAttachmentDetails.
        :rtype: str
        """
        return self._flow_log_config_id

    @flow_log_config_id.setter
    def flow_log_config_id(self, flow_log_config_id):
        """
        Sets the flow_log_config_id of this CreateFlowLogConfigAttachmentDetails.
        The `OCID`__ of the flow log configuration to attach.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param flow_log_config_id: The flow_log_config_id of this CreateFlowLogConfigAttachmentDetails.
        :type: str
        """
        self._flow_log_config_id = flow_log_config_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
