# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateFlowLogConfigDetails(object):
    """
    CreateFlowLogConfigDetails model.
    """

    #: A constant which can be used with the flow_log_type property of a CreateFlowLogConfigDetails.
    #: This constant has a value of "ALL"
    FLOW_LOG_TYPE_ALL = "ALL"

    def __init__(self, **kwargs):
        """
        Initializes a new CreateFlowLogConfigDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateFlowLogConfigDetails.
        :type compartment_id: str

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateFlowLogConfigDetails.
        :type defined_tags: dict(str, dict(str, object))

        :param display_name:
            The value to assign to the display_name property of this CreateFlowLogConfigDetails.
        :type display_name: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateFlowLogConfigDetails.
        :type freeform_tags: dict(str, str)

        :param flow_log_type:
            The value to assign to the flow_log_type property of this CreateFlowLogConfigDetails.
            Allowed values for this property are: "ALL"
        :type flow_log_type: str

        :param destination:
            The value to assign to the destination property of this CreateFlowLogConfigDetails.
        :type destination: FlowLogDestination

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'defined_tags': 'dict(str, dict(str, object))',
            'display_name': 'str',
            'freeform_tags': 'dict(str, str)',
            'flow_log_type': 'str',
            'destination': 'FlowLogDestination'
        }

        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'defined_tags': 'definedTags',
            'display_name': 'displayName',
            'freeform_tags': 'freeformTags',
            'flow_log_type': 'flowLogType',
            'destination': 'destination'
        }

        self._compartment_id = None
        self._defined_tags = None
        self._display_name = None
        self._freeform_tags = None
        self._flow_log_type = None
        self._destination = None

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateFlowLogConfigDetails.
        The `OCID`__ of the compartment to contain the
        flow log configuration.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this CreateFlowLogConfigDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateFlowLogConfigDetails.
        The `OCID`__ of the compartment to contain the
        flow log configuration.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this CreateFlowLogConfigDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateFlowLogConfigDetails.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CreateFlowLogConfigDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateFlowLogConfigDetails.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CreateFlowLogConfigDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def display_name(self):
        """
        Gets the display_name of this CreateFlowLogConfigDetails.
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid
        entering confidential information.


        :return: The display_name of this CreateFlowLogConfigDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateFlowLogConfigDetails.
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid
        entering confidential information.


        :param display_name: The display_name of this CreateFlowLogConfigDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateFlowLogConfigDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CreateFlowLogConfigDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateFlowLogConfigDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CreateFlowLogConfigDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def flow_log_type(self):
        """
        **[Required]** Gets the flow_log_type of this CreateFlowLogConfigDetails.
        Type or types of flow logs to store. `ALL` includes records for both accepted traffic and
        rejected traffic.

        Allowed values for this property are: "ALL"


        :return: The flow_log_type of this CreateFlowLogConfigDetails.
        :rtype: str
        """
        return self._flow_log_type

    @flow_log_type.setter
    def flow_log_type(self, flow_log_type):
        """
        Sets the flow_log_type of this CreateFlowLogConfigDetails.
        Type or types of flow logs to store. `ALL` includes records for both accepted traffic and
        rejected traffic.


        :param flow_log_type: The flow_log_type of this CreateFlowLogConfigDetails.
        :type: str
        """
        allowed_values = ["ALL"]
        if not value_allowed_none_or_none_sentinel(flow_log_type, allowed_values):
            raise ValueError(
                "Invalid value for `flow_log_type`, must be None or one of {0}"
                .format(allowed_values)
            )
        self._flow_log_type = flow_log_type

    @property
    def destination(self):
        """
        **[Required]** Gets the destination of this CreateFlowLogConfigDetails.
        Where to store the flow logs.


        :return: The destination of this CreateFlowLogConfigDetails.
        :rtype: FlowLogDestination
        """
        return self._destination

    @destination.setter
    def destination(self, destination):
        """
        Sets the destination of this CreateFlowLogConfigDetails.
        Where to store the flow logs.


        :param destination: The destination of this CreateFlowLogConfigDetails.
        :type: FlowLogDestination
        """
        self._destination = destination

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
