# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreatePrivateEndpointDetails(object):
    """
    Details to create a private endpoint.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreatePrivateEndpointDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this CreatePrivateEndpointDetails.
        :type compartment_id: str

        :param defined_tags:
            The value to assign to the defined_tags property of this CreatePrivateEndpointDetails.
        :type defined_tags: dict(str, dict(str, object))

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreatePrivateEndpointDetails.
        :type freeform_tags: dict(str, str)

        :param display_name:
            The value to assign to the display_name property of this CreatePrivateEndpointDetails.
        :type display_name: str

        :param description:
            The value to assign to the description property of this CreatePrivateEndpointDetails.
        :type description: str

        :param endpoint_service_id:
            The value to assign to the endpoint_service_id property of this CreatePrivateEndpointDetails.
        :type endpoint_service_id: str

        :param subnet_id:
            The value to assign to the subnet_id property of this CreatePrivateEndpointDetails.
        :type subnet_id: str

        :param endpoint_fqdn:
            The value to assign to the endpoint_fqdn property of this CreatePrivateEndpointDetails.
        :type endpoint_fqdn: str

        :param nsg_ids:
            The value to assign to the nsg_ids property of this CreatePrivateEndpointDetails.
        :type nsg_ids: list[str]

        :param private_endpoint_ip:
            The value to assign to the private_endpoint_ip property of this CreatePrivateEndpointDetails.
        :type private_endpoint_ip: str

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'defined_tags': 'dict(str, dict(str, object))',
            'freeform_tags': 'dict(str, str)',
            'display_name': 'str',
            'description': 'str',
            'endpoint_service_id': 'str',
            'subnet_id': 'str',
            'endpoint_fqdn': 'str',
            'nsg_ids': 'list[str]',
            'private_endpoint_ip': 'str'
        }

        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'defined_tags': 'definedTags',
            'freeform_tags': 'freeformTags',
            'display_name': 'displayName',
            'description': 'description',
            'endpoint_service_id': 'endpointServiceId',
            'subnet_id': 'subnetId',
            'endpoint_fqdn': 'endpointFqdn',
            'nsg_ids': 'nsgIds',
            'private_endpoint_ip': 'privateEndpointIp'
        }

        self._compartment_id = None
        self._defined_tags = None
        self._freeform_tags = None
        self._display_name = None
        self._description = None
        self._endpoint_service_id = None
        self._subnet_id = None
        self._endpoint_fqdn = None
        self._nsg_ids = None
        self._private_endpoint_ip = None

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreatePrivateEndpointDetails.
        The `OCID`__ of the compartment to contain the
        private endpoint.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this CreatePrivateEndpointDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreatePrivateEndpointDetails.
        The `OCID`__ of the compartment to contain the
        private endpoint.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this CreatePrivateEndpointDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreatePrivateEndpointDetails.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CreatePrivateEndpointDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreatePrivateEndpointDetails.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CreatePrivateEndpointDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreatePrivateEndpointDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CreatePrivateEndpointDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreatePrivateEndpointDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CreatePrivateEndpointDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def display_name(self):
        """
        Gets the display_name of this CreatePrivateEndpointDetails.
        A user-friendly name. Does not have to be unique.
        Avoid entering confidential information.


        :return: The display_name of this CreatePrivateEndpointDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreatePrivateEndpointDetails.
        A user-friendly name. Does not have to be unique.
        Avoid entering confidential information.


        :param display_name: The display_name of this CreatePrivateEndpointDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this CreatePrivateEndpointDetails.
        A description of this private endpoint.


        :return: The description of this CreatePrivateEndpointDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CreatePrivateEndpointDetails.
        A description of this private endpoint.


        :param description: The description of this CreatePrivateEndpointDetails.
        :type: str
        """
        self._description = description

    @property
    def endpoint_service_id(self):
        """
        **[Required]** Gets the endpoint_service_id of this CreatePrivateEndpointDetails.
        The `OCID`__ of the endpoint service that will be
        associated with the private endpoint.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The endpoint_service_id of this CreatePrivateEndpointDetails.
        :rtype: str
        """
        return self._endpoint_service_id

    @endpoint_service_id.setter
    def endpoint_service_id(self, endpoint_service_id):
        """
        Sets the endpoint_service_id of this CreatePrivateEndpointDetails.
        The `OCID`__ of the endpoint service that will be
        associated with the private endpoint.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param endpoint_service_id: The endpoint_service_id of this CreatePrivateEndpointDetails.
        :type: str
        """
        self._endpoint_service_id = endpoint_service_id

    @property
    def subnet_id(self):
        """
        **[Required]** Gets the subnet_id of this CreatePrivateEndpointDetails.
        The `OCID`__ of the customer's subnet where the private endpoint VNIC will reside.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The subnet_id of this CreatePrivateEndpointDetails.
        :rtype: str
        """
        return self._subnet_id

    @subnet_id.setter
    def subnet_id(self, subnet_id):
        """
        Sets the subnet_id of this CreatePrivateEndpointDetails.
        The `OCID`__ of the customer's subnet where the private endpoint VNIC will reside.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param subnet_id: The subnet_id of this CreatePrivateEndpointDetails.
        :type: str
        """
        self._subnet_id = subnet_id

    @property
    def endpoint_fqdn(self):
        """
        Gets the endpoint_fqdn of this CreatePrivateEndpointDetails.
        The three-label FQDN to use for the private endpoint. The customer VCN's DNS records are
        updated with this FQDN.

        For important information about how this attribute is used, see the discussion
        of DNS and FQDNs in :class:`PrivateEndpoint`.
        changed.

        Example: `xyz.oraclecloud.com`


        :return: The endpoint_fqdn of this CreatePrivateEndpointDetails.
        :rtype: str
        """
        return self._endpoint_fqdn

    @endpoint_fqdn.setter
    def endpoint_fqdn(self, endpoint_fqdn):
        """
        Sets the endpoint_fqdn of this CreatePrivateEndpointDetails.
        The three-label FQDN to use for the private endpoint. The customer VCN's DNS records are
        updated with this FQDN.

        For important information about how this attribute is used, see the discussion
        of DNS and FQDNs in :class:`PrivateEndpoint`.
        changed.

        Example: `xyz.oraclecloud.com`


        :param endpoint_fqdn: The endpoint_fqdn of this CreatePrivateEndpointDetails.
        :type: str
        """
        self._endpoint_fqdn = endpoint_fqdn

    @property
    def nsg_ids(self):
        """
        Gets the nsg_ids of this CreatePrivateEndpointDetails.
        A list of the OCIDs of the network security groups (NSGs) to add the private endpoint's VNIC to.
        For more information about NSGs, see
        :class:`NetworkSecurityGroup`.


        :return: The nsg_ids of this CreatePrivateEndpointDetails.
        :rtype: list[str]
        """
        return self._nsg_ids

    @nsg_ids.setter
    def nsg_ids(self, nsg_ids):
        """
        Sets the nsg_ids of this CreatePrivateEndpointDetails.
        A list of the OCIDs of the network security groups (NSGs) to add the private endpoint's VNIC to.
        For more information about NSGs, see
        :class:`NetworkSecurityGroup`.


        :param nsg_ids: The nsg_ids of this CreatePrivateEndpointDetails.
        :type: list[str]
        """
        self._nsg_ids = nsg_ids

    @property
    def private_endpoint_ip(self):
        """
        Gets the private_endpoint_ip of this CreatePrivateEndpointDetails.
        The private IP address to assign to this private endpoint. If you provide a value,
        it must be an available IP address in the customer's subnet. If it's not available, an error
        is returned.

        If you do not provide a value, an available IP address in the subnet is automatically chosen.


        :return: The private_endpoint_ip of this CreatePrivateEndpointDetails.
        :rtype: str
        """
        return self._private_endpoint_ip

    @private_endpoint_ip.setter
    def private_endpoint_ip(self, private_endpoint_ip):
        """
        Sets the private_endpoint_ip of this CreatePrivateEndpointDetails.
        The private IP address to assign to this private endpoint. If you provide a value,
        it must be an available IP address in the customer's subnet. If it's not available, an error
        is returned.

        If you do not provide a value, an available IP address in the subnet is automatically chosen.


        :param private_endpoint_ip: The private_endpoint_ip of this CreatePrivateEndpointDetails.
        :type: str
        """
        self._private_endpoint_ip = private_endpoint_ip

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
