# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class EnableReverseConnectionsDetails(object):
    """
    Details for enabling reverse connections functionality on the Private Endpoint
    """

    #: A constant which can be used with the default_dns_resolution_context property of a EnableReverseConnectionsDetails.
    #: This constant has a value of "SERVICE"
    DEFAULT_DNS_RESOLUTION_CONTEXT_SERVICE = "SERVICE"

    #: A constant which can be used with the default_dns_resolution_context property of a EnableReverseConnectionsDetails.
    #: This constant has a value of "CUSTOMER"
    DEFAULT_DNS_RESOLUTION_CONTEXT_CUSTOMER = "CUSTOMER"

    def __init__(self, **kwargs):
        """
        Initializes a new EnableReverseConnectionsDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param reverse_connections_origin_ips:
            The value to assign to the reverse_connections_origin_ips property of this EnableReverseConnectionsDetails.
        :type reverse_connections_origin_ips: list[ReverseConnectionsSourceIpDetails]

        :param dns_proxy_ip:
            The value to assign to the dns_proxy_ip property of this EnableReverseConnectionsDetails.
        :type dns_proxy_ip: str

        :param default_dns_resolution_context:
            The value to assign to the default_dns_resolution_context property of this EnableReverseConnectionsDetails.
            Allowed values for this property are: "SERVICE", "CUSTOMER"
        :type default_dns_resolution_context: str

        :param excluded_dns_zones:
            The value to assign to the excluded_dns_zones property of this EnableReverseConnectionsDetails.
        :type excluded_dns_zones: list[str]

        :param service_subnet_id:
            The value to assign to the service_subnet_id property of this EnableReverseConnectionsDetails.
        :type service_subnet_id: str

        """
        self.swagger_types = {
            'reverse_connections_origin_ips': 'list[ReverseConnectionsSourceIpDetails]',
            'dns_proxy_ip': 'str',
            'default_dns_resolution_context': 'str',
            'excluded_dns_zones': 'list[str]',
            'service_subnet_id': 'str'
        }

        self.attribute_map = {
            'reverse_connections_origin_ips': 'reverseConnectionsOriginIps',
            'dns_proxy_ip': 'dnsProxyIp',
            'default_dns_resolution_context': 'defaultDnsResolutionContext',
            'excluded_dns_zones': 'excludedDnsZones',
            'service_subnet_id': 'serviceSubnetId'
        }

        self._reverse_connections_origin_ips = None
        self._dns_proxy_ip = None
        self._default_dns_resolution_context = None
        self._excluded_dns_zones = None
        self._service_subnet_id = None

    @property
    def reverse_connections_origin_ips(self):
        """
        Gets the reverse_connections_origin_ips of this EnableReverseConnectionsDetails.
        IP addresses in customer VCN which will be used as source IPs for reverse connections from the service provider's VCN to the customer VCN.
        If no list is specified or an empty list is provided, one IP address will be picked from customer subnet's CIDR.


        :return: The reverse_connections_origin_ips of this EnableReverseConnectionsDetails.
        :rtype: list[ReverseConnectionsSourceIpDetails]
        """
        return self._reverse_connections_origin_ips

    @reverse_connections_origin_ips.setter
    def reverse_connections_origin_ips(self, reverse_connections_origin_ips):
        """
        Sets the reverse_connections_origin_ips of this EnableReverseConnectionsDetails.
        IP addresses in customer VCN which will be used as source IPs for reverse connections from the service provider's VCN to the customer VCN.
        If no list is specified or an empty list is provided, one IP address will be picked from customer subnet's CIDR.


        :param reverse_connections_origin_ips: The reverse_connections_origin_ips of this EnableReverseConnectionsDetails.
        :type: list[ReverseConnectionsSourceIpDetails]
        """
        self._reverse_connections_origin_ips = reverse_connections_origin_ips

    @property
    def dns_proxy_ip(self):
        """
        Gets the dns_proxy_ip of this EnableReverseConnectionsDetails.
        IP address in service provider VCN that should be used as DNS proxy for resolving the DNS FQDN to destination IP addresses for reverse connections.
        If not provided, some available IP address will be picked from service provider subnet's CIDR.


        :return: The dns_proxy_ip of this EnableReverseConnectionsDetails.
        :rtype: str
        """
        return self._dns_proxy_ip

    @dns_proxy_ip.setter
    def dns_proxy_ip(self, dns_proxy_ip):
        """
        Sets the dns_proxy_ip of this EnableReverseConnectionsDetails.
        IP address in service provider VCN that should be used as DNS proxy for resolving the DNS FQDN to destination IP addresses for reverse connections.
        If not provided, some available IP address will be picked from service provider subnet's CIDR.


        :param dns_proxy_ip: The dns_proxy_ip of this EnableReverseConnectionsDetails.
        :type: str
        """
        self._dns_proxy_ip = dns_proxy_ip

    @property
    def default_dns_resolution_context(self):
        """
        Gets the default_dns_resolution_context of this EnableReverseConnectionsDetails.
        Context in which the DNS proxy will resolve the DNS queries in. The default is `SERVICE`.

        Allowed values:

         * `SERVICE` : All DNS queries will be resolved within the service VCN's DNS context, unless the FQDN belongs to one of zones in the `excludedDnsZones` list.

         * `CUSTOMER` : All DNS queries will be resolved within the customer VCN's DNS context, unless the FQDN belongs to one of zones in the `excludedDnsZones` list.

        Allowed values for this property are: "SERVICE", "CUSTOMER"


        :return: The default_dns_resolution_context of this EnableReverseConnectionsDetails.
        :rtype: str
        """
        return self._default_dns_resolution_context

    @default_dns_resolution_context.setter
    def default_dns_resolution_context(self, default_dns_resolution_context):
        """
        Sets the default_dns_resolution_context of this EnableReverseConnectionsDetails.
        Context in which the DNS proxy will resolve the DNS queries in. The default is `SERVICE`.

        Allowed values:

         * `SERVICE` : All DNS queries will be resolved within the service VCN's DNS context, unless the FQDN belongs to one of zones in the `excludedDnsZones` list.

         * `CUSTOMER` : All DNS queries will be resolved within the customer VCN's DNS context, unless the FQDN belongs to one of zones in the `excludedDnsZones` list.


        :param default_dns_resolution_context: The default_dns_resolution_context of this EnableReverseConnectionsDetails.
        :type: str
        """
        allowed_values = ["SERVICE", "CUSTOMER"]
        if not value_allowed_none_or_none_sentinel(default_dns_resolution_context, allowed_values):
            raise ValueError(
                "Invalid value for `default_dns_resolution_context`, must be None or one of {0}"
                .format(allowed_values)
            )
        self._default_dns_resolution_context = default_dns_resolution_context

    @property
    def excluded_dns_zones(self):
        """
        **[Required]** Gets the excluded_dns_zones of this EnableReverseConnectionsDetails.
        List of DNS zones to exclude from the default DNS resolution context.


        :return: The excluded_dns_zones of this EnableReverseConnectionsDetails.
        :rtype: list[str]
        """
        return self._excluded_dns_zones

    @excluded_dns_zones.setter
    def excluded_dns_zones(self, excluded_dns_zones):
        """
        Sets the excluded_dns_zones of this EnableReverseConnectionsDetails.
        List of DNS zones to exclude from the default DNS resolution context.


        :param excluded_dns_zones: The excluded_dns_zones of this EnableReverseConnectionsDetails.
        :type: list[str]
        """
        self._excluded_dns_zones = excluded_dns_zones

    @property
    def service_subnet_id(self):
        """
        **[Required]** Gets the service_subnet_id of this EnableReverseConnectionsDetails.
        The `OCID`__ of the service provider's subnet, in which DNS proxy endpoint will be spwaned.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The service_subnet_id of this EnableReverseConnectionsDetails.
        :rtype: str
        """
        return self._service_subnet_id

    @service_subnet_id.setter
    def service_subnet_id(self, service_subnet_id):
        """
        Sets the service_subnet_id of this EnableReverseConnectionsDetails.
        The `OCID`__ of the service provider's subnet, in which DNS proxy endpoint will be spwaned.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param service_subnet_id: The service_subnet_id of this EnableReverseConnectionsDetails.
        :type: str
        """
        self._service_subnet_id = service_subnet_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
