# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class EndpointService(object):
    """
    Required for Oracle services that offer customers private endpoints for private access to the
    service.

    An endpoint service is an object that resides in the Oracle service's VCN and represents the IP addresses
    for accessing the service. An endpoint service can be associated with one or more private
    endpoints, which reside in customer VCNs (see :class:`PrivateEndpoint`).

    To use any of the API operations, you must be authorized in an IAM policy. If you're not authorized,
    talk to an administrator. If you're an administrator who needs to write policies to give users access, see
    `Getting Started with Policies`__.

    **Warning:** Oracle recommends that you avoid using any confidential information when you
    supply string values using the API.

    __ https://docs.cloud.oracle.com/Content/Identity/Concepts/policygetstarted.htm
    """

    #: A constant which can be used with the lifecycle_state property of a EndpointService.
    #: This constant has a value of "PROVISIONING"
    LIFECYCLE_STATE_PROVISIONING = "PROVISIONING"

    #: A constant which can be used with the lifecycle_state property of a EndpointService.
    #: This constant has a value of "AVAILABLE"
    LIFECYCLE_STATE_AVAILABLE = "AVAILABLE"

    #: A constant which can be used with the lifecycle_state property of a EndpointService.
    #: This constant has a value of "TERMINATING"
    LIFECYCLE_STATE_TERMINATING = "TERMINATING"

    #: A constant which can be used with the lifecycle_state property of a EndpointService.
    #: This constant has a value of "TERMINATED"
    LIFECYCLE_STATE_TERMINATED = "TERMINATED"

    def __init__(self, **kwargs):
        """
        Initializes a new EndpointService object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this EndpointService.
        :type id: str

        :param vcn_id:
            The value to assign to the vcn_id property of this EndpointService.
        :type vcn_id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this EndpointService.
        :type compartment_id: str

        :param description:
            The value to assign to the description property of this EndpointService.
        :type description: str

        :param display_name:
            The value to assign to the display_name property of this EndpointService.
        :type display_name: str

        :param are_multiple_private_endpoints_per_vcn_allowed:
            The value to assign to the are_multiple_private_endpoints_per_vcn_allowed property of this EndpointService.
        :type are_multiple_private_endpoints_per_vcn_allowed: bool

        :param is_vcn_metadata_enabled:
            The value to assign to the is_vcn_metadata_enabled property of this EndpointService.
        :type is_vcn_metadata_enabled: bool

        :param service_ips:
            The value to assign to the service_ips property of this EndpointService.
        :type service_ips: list[EndpointServiceIpDetails]

        :param ports:
            The value to assign to the ports property of this EndpointService.
        :type ports: list[int]

        :param endpoint_fqdn:
            The value to assign to the endpoint_fqdn property of this EndpointService.
        :type endpoint_fqdn: str

        :param time_created:
            The value to assign to the time_created property of this EndpointService.
        :type time_created: datetime

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this EndpointService.
            Allowed values for this property are: "PROVISIONING", "AVAILABLE", "TERMINATING", "TERMINATED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param defined_tags:
            The value to assign to the defined_tags property of this EndpointService.
        :type defined_tags: dict(str, dict(str, object))

        :param freeform_tags:
            The value to assign to the freeform_tags property of this EndpointService.
        :type freeform_tags: dict(str, str)

        """
        self.swagger_types = {
            'id': 'str',
            'vcn_id': 'str',
            'compartment_id': 'str',
            'description': 'str',
            'display_name': 'str',
            'are_multiple_private_endpoints_per_vcn_allowed': 'bool',
            'is_vcn_metadata_enabled': 'bool',
            'service_ips': 'list[EndpointServiceIpDetails]',
            'ports': 'list[int]',
            'endpoint_fqdn': 'str',
            'time_created': 'datetime',
            'lifecycle_state': 'str',
            'defined_tags': 'dict(str, dict(str, object))',
            'freeform_tags': 'dict(str, str)'
        }

        self.attribute_map = {
            'id': 'id',
            'vcn_id': 'vcnId',
            'compartment_id': 'compartmentId',
            'description': 'description',
            'display_name': 'displayName',
            'are_multiple_private_endpoints_per_vcn_allowed': 'areMultiplePrivateEndpointsPerVcnAllowed',
            'is_vcn_metadata_enabled': 'isVcnMetadataEnabled',
            'service_ips': 'serviceIps',
            'ports': 'ports',
            'endpoint_fqdn': 'endpointFqdn',
            'time_created': 'timeCreated',
            'lifecycle_state': 'lifecycleState',
            'defined_tags': 'definedTags',
            'freeform_tags': 'freeformTags'
        }

        self._id = None
        self._vcn_id = None
        self._compartment_id = None
        self._description = None
        self._display_name = None
        self._are_multiple_private_endpoints_per_vcn_allowed = None
        self._is_vcn_metadata_enabled = None
        self._service_ips = None
        self._ports = None
        self._endpoint_fqdn = None
        self._time_created = None
        self._lifecycle_state = None
        self._defined_tags = None
        self._freeform_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this EndpointService.
        The `OCID`__ of the endpoint service.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The id of this EndpointService.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this EndpointService.
        The `OCID`__ of the endpoint service.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param id: The id of this EndpointService.
        :type: str
        """
        self._id = id

    @property
    def vcn_id(self):
        """
        **[Required]** Gets the vcn_id of this EndpointService.
        The `OCID`__ of the service VCN that the endpoint
        service belongs to.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The vcn_id of this EndpointService.
        :rtype: str
        """
        return self._vcn_id

    @vcn_id.setter
    def vcn_id(self, vcn_id):
        """
        Sets the vcn_id of this EndpointService.
        The `OCID`__ of the service VCN that the endpoint
        service belongs to.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param vcn_id: The vcn_id of this EndpointService.
        :type: str
        """
        self._vcn_id = vcn_id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this EndpointService.
        The `OCID`__ of the compartment that contains the
        endpoint service.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this EndpointService.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this EndpointService.
        The `OCID`__ of the compartment that contains the
        endpoint service.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this EndpointService.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def description(self):
        """
        Gets the description of this EndpointService.
        A description of the endpoint service. For Oracle services that use the \"trusted\" mode of the
        private endpoint service, customers never see this description.


        :return: The description of this EndpointService.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this EndpointService.
        A description of the endpoint service. For Oracle services that use the \"trusted\" mode of the
        private endpoint service, customers never see this description.


        :param description: The description of this EndpointService.
        :type: str
        """
        self._description = description

    @property
    def display_name(self):
        """
        Gets the display_name of this EndpointService.
        A friendly name for the endpoint service. Must be unique within the VCN.


        :return: The display_name of this EndpointService.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this EndpointService.
        A friendly name for the endpoint service. Must be unique within the VCN.


        :param display_name: The display_name of this EndpointService.
        :type: str
        """
        self._display_name = display_name

    @property
    def are_multiple_private_endpoints_per_vcn_allowed(self):
        """
        Gets the are_multiple_private_endpoints_per_vcn_allowed of this EndpointService.
        Some Oracle services want to restrict access to the resources represented by an endpoint service so
        that only a single private endpoint in the customer VCN has access.

        For example, the endpoint service might represent a particular service resource (such as a
        particular database). The service might want to allow access to that particular resource
        from only a single private endpoint.

        Defaults to `false`.

        Example: `true`


        :return: The are_multiple_private_endpoints_per_vcn_allowed of this EndpointService.
        :rtype: bool
        """
        return self._are_multiple_private_endpoints_per_vcn_allowed

    @are_multiple_private_endpoints_per_vcn_allowed.setter
    def are_multiple_private_endpoints_per_vcn_allowed(self, are_multiple_private_endpoints_per_vcn_allowed):
        """
        Sets the are_multiple_private_endpoints_per_vcn_allowed of this EndpointService.
        Some Oracle services want to restrict access to the resources represented by an endpoint service so
        that only a single private endpoint in the customer VCN has access.

        For example, the endpoint service might represent a particular service resource (such as a
        particular database). The service might want to allow access to that particular resource
        from only a single private endpoint.

        Defaults to `false`.

        Example: `true`


        :param are_multiple_private_endpoints_per_vcn_allowed: The are_multiple_private_endpoints_per_vcn_allowed of this EndpointService.
        :type: bool
        """
        self._are_multiple_private_endpoints_per_vcn_allowed = are_multiple_private_endpoints_per_vcn_allowed

    @property
    def is_vcn_metadata_enabled(self):
        """
        Gets the is_vcn_metadata_enabled of this EndpointService.
        Reserved for future use.


        :return: The is_vcn_metadata_enabled of this EndpointService.
        :rtype: bool
        """
        return self._is_vcn_metadata_enabled

    @is_vcn_metadata_enabled.setter
    def is_vcn_metadata_enabled(self, is_vcn_metadata_enabled):
        """
        Sets the is_vcn_metadata_enabled of this EndpointService.
        Reserved for future use.


        :param is_vcn_metadata_enabled: The is_vcn_metadata_enabled of this EndpointService.
        :type: bool
        """
        self._is_vcn_metadata_enabled = is_vcn_metadata_enabled

    @property
    def service_ips(self):
        """
        **[Required]** Gets the service_ips of this EndpointService.
        List of service IP addresses (in the service VCN) that handle requests to the endpoint service.


        :return: The service_ips of this EndpointService.
        :rtype: list[EndpointServiceIpDetails]
        """
        return self._service_ips

    @service_ips.setter
    def service_ips(self, service_ips):
        """
        Sets the service_ips of this EndpointService.
        List of service IP addresses (in the service VCN) that handle requests to the endpoint service.


        :param service_ips: The service_ips of this EndpointService.
        :type: list[EndpointServiceIpDetails]
        """
        self._service_ips = service_ips

    @property
    def ports(self):
        """
        **[Required]** Gets the ports of this EndpointService.
        The ports on the endpoint service IPs that are open for private endpoint traffic for this
        endpoint service. If you provide no ports, all open ports on the service IPs are accessible.


        :return: The ports of this EndpointService.
        :rtype: list[int]
        """
        return self._ports

    @ports.setter
    def ports(self, ports):
        """
        Sets the ports of this EndpointService.
        The ports on the endpoint service IPs that are open for private endpoint traffic for this
        endpoint service. If you provide no ports, all open ports on the service IPs are accessible.


        :param ports: The ports of this EndpointService.
        :type: list[int]
        """
        self._ports = ports

    @property
    def endpoint_fqdn(self):
        """
        **[Required]** Gets the endpoint_fqdn of this EndpointService.
        The three-label FQDN to use for all private endpoints associated with this endpoint
        service. This attribute's value cannot be changed.

        For important information about how this attribute is used, see the discussion
        of DNS and FQDNs in :class:`PrivateEndpoint`.

        Example: `xyz.oraclecloud.com`


        :return: The endpoint_fqdn of this EndpointService.
        :rtype: str
        """
        return self._endpoint_fqdn

    @endpoint_fqdn.setter
    def endpoint_fqdn(self, endpoint_fqdn):
        """
        Sets the endpoint_fqdn of this EndpointService.
        The three-label FQDN to use for all private endpoints associated with this endpoint
        service. This attribute's value cannot be changed.

        For important information about how this attribute is used, see the discussion
        of DNS and FQDNs in :class:`PrivateEndpoint`.

        Example: `xyz.oraclecloud.com`


        :param endpoint_fqdn: The endpoint_fqdn of this EndpointService.
        :type: str
        """
        self._endpoint_fqdn = endpoint_fqdn

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this EndpointService.
        The date and time the endpoint service was created, in the format defined by RFC3339.
        Example: `2016-08-25T21:10:29.600Z`


        :return: The time_created of this EndpointService.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this EndpointService.
        The date and time the endpoint service was created, in the format defined by RFC3339.
        Example: `2016-08-25T21:10:29.600Z`


        :param time_created: The time_created of this EndpointService.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this EndpointService.
        The endpoint service's current lifecycle state.

        Allowed values for this property are: "PROVISIONING", "AVAILABLE", "TERMINATING", "TERMINATED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this EndpointService.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this EndpointService.
        The endpoint service's current lifecycle state.


        :param lifecycle_state: The lifecycle_state of this EndpointService.
        :type: str
        """
        allowed_values = ["PROVISIONING", "AVAILABLE", "TERMINATING", "TERMINATED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this EndpointService.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this EndpointService.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this EndpointService.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this EndpointService.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this EndpointService.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this EndpointService.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this EndpointService.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this EndpointService.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
