# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class EndpointServiceIpDetails(object):
    """
    Information about an IP address (in the service VCN) that handles requests to the endpoint service.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new EndpointServiceIpDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param service_ip:
            The value to assign to the service_ip property of this EndpointServiceIpDetails.
        :type service_ip: str

        """
        self.swagger_types = {
            'service_ip': 'str'
        }

        self.attribute_map = {
            'service_ip': 'serviceIp'
        }

        self._service_ip = None

    @property
    def service_ip(self):
        """
        **[Required]** Gets the service_ip of this EndpointServiceIpDetails.
        An IP address (in the service VCN) that handles requests to the endpoint service.


        :return: The service_ip of this EndpointServiceIpDetails.
        :rtype: str
        """
        return self._service_ip

    @service_ip.setter
    def service_ip(self, service_ip):
        """
        Sets the service_ip of this EndpointServiceIpDetails.
        An IP address (in the service VCN) that handles requests to the endpoint service.


        :param service_ip: The service_ip of this EndpointServiceIpDetails.
        :type: str
        """
        self._service_ip = service_ip

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
