# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class EndpointServiceSummary(object):
    """
    A summary of endpoint service information. This object is returned when listing endpoint
    services.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new EndpointServiceSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this EndpointServiceSummary.
        :type id: str

        :param vcn_id:
            The value to assign to the vcn_id property of this EndpointServiceSummary.
        :type vcn_id: str

        :param display_name:
            The value to assign to the display_name property of this EndpointServiceSummary.
        :type display_name: str

        """
        self.swagger_types = {
            'id': 'str',
            'vcn_id': 'str',
            'display_name': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'vcn_id': 'vcnId',
            'display_name': 'displayName'
        }

        self._id = None
        self._vcn_id = None
        self._display_name = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this EndpointServiceSummary.
        The `OCID`__ of the endpoint service.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The id of this EndpointServiceSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this EndpointServiceSummary.
        The `OCID`__ of the endpoint service.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param id: The id of this EndpointServiceSummary.
        :type: str
        """
        self._id = id

    @property
    def vcn_id(self):
        """
        **[Required]** Gets the vcn_id of this EndpointServiceSummary.
        The `OCID`__ of the service VCN that the endpoint
        service belongs to.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The vcn_id of this EndpointServiceSummary.
        :rtype: str
        """
        return self._vcn_id

    @vcn_id.setter
    def vcn_id(self, vcn_id):
        """
        Sets the vcn_id of this EndpointServiceSummary.
        The `OCID`__ of the service VCN that the endpoint
        service belongs to.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param vcn_id: The vcn_id of this EndpointServiceSummary.
        :type: str
        """
        self._vcn_id = vcn_id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this EndpointServiceSummary.
        The endpoint service's friendly name.


        :return: The display_name of this EndpointServiceSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this EndpointServiceSummary.
        The endpoint service's friendly name.


        :param display_name: The display_name of this EndpointServiceSummary.
        :type: str
        """
        self._display_name = display_name

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
