# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class FlowLogConfigAttachment(object):
    """
    Represents an attachment between a flow log configuration and a resource such as a subnet. By
    creating a `FlowLogConfigAttachment`, you turn on flow logs for the attached resource. See
    :func:`create_flow_log_config_attachment`.

    **Warning:** Oracle recommends that you avoid using any confidential information when you
    supply string values using the API.
    """

    #: A constant which can be used with the lifecycle_state property of a FlowLogConfigAttachment.
    #: This constant has a value of "PROVISIONING"
    LIFECYCLE_STATE_PROVISIONING = "PROVISIONING"

    #: A constant which can be used with the lifecycle_state property of a FlowLogConfigAttachment.
    #: This constant has a value of "AVAILABLE"
    LIFECYCLE_STATE_AVAILABLE = "AVAILABLE"

    #: A constant which can be used with the lifecycle_state property of a FlowLogConfigAttachment.
    #: This constant has a value of "TERMINATING"
    LIFECYCLE_STATE_TERMINATING = "TERMINATING"

    #: A constant which can be used with the lifecycle_state property of a FlowLogConfigAttachment.
    #: This constant has a value of "TERMINATED"
    LIFECYCLE_STATE_TERMINATED = "TERMINATED"

    #: A constant which can be used with the target_entity_type property of a FlowLogConfigAttachment.
    #: This constant has a value of "SUBNET"
    TARGET_ENTITY_TYPE_SUBNET = "SUBNET"

    def __init__(self, **kwargs):
        """
        Initializes a new FlowLogConfigAttachment object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this FlowLogConfigAttachment.
        :type compartment_id: str

        :param display_name:
            The value to assign to the display_name property of this FlowLogConfigAttachment.
        :type display_name: str

        :param id:
            The value to assign to the id property of this FlowLogConfigAttachment.
        :type id: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this FlowLogConfigAttachment.
            Allowed values for this property are: "PROVISIONING", "AVAILABLE", "TERMINATING", "TERMINATED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param target_entity_id:
            The value to assign to the target_entity_id property of this FlowLogConfigAttachment.
        :type target_entity_id: str

        :param target_entity_type:
            The value to assign to the target_entity_type property of this FlowLogConfigAttachment.
            Allowed values for this property are: "SUBNET", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type target_entity_type: str

        :param flow_log_config_id:
            The value to assign to the flow_log_config_id property of this FlowLogConfigAttachment.
        :type flow_log_config_id: str

        :param time_created:
            The value to assign to the time_created property of this FlowLogConfigAttachment.
        :type time_created: datetime

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'display_name': 'str',
            'id': 'str',
            'lifecycle_state': 'str',
            'target_entity_id': 'str',
            'target_entity_type': 'str',
            'flow_log_config_id': 'str',
            'time_created': 'datetime'
        }

        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'display_name': 'displayName',
            'id': 'id',
            'lifecycle_state': 'lifecycleState',
            'target_entity_id': 'targetEntityId',
            'target_entity_type': 'targetEntityType',
            'flow_log_config_id': 'flowLogConfigId',
            'time_created': 'timeCreated'
        }

        self._compartment_id = None
        self._display_name = None
        self._id = None
        self._lifecycle_state = None
        self._target_entity_id = None
        self._target_entity_type = None
        self._flow_log_config_id = None
        self._time_created = None

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this FlowLogConfigAttachment.
        The `OCID`__ of the compartment containing the
        flow log configuration attachment.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this FlowLogConfigAttachment.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this FlowLogConfigAttachment.
        The `OCID`__ of the compartment containing the
        flow log configuration attachment.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this FlowLogConfigAttachment.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this FlowLogConfigAttachment.
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid
        entering confidential information.


        :return: The display_name of this FlowLogConfigAttachment.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this FlowLogConfigAttachment.
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid
        entering confidential information.


        :param display_name: The display_name of this FlowLogConfigAttachment.
        :type: str
        """
        self._display_name = display_name

    @property
    def id(self):
        """
        **[Required]** Gets the id of this FlowLogConfigAttachment.
        The flow log configuration attachment's `OCID`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The id of this FlowLogConfigAttachment.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this FlowLogConfigAttachment.
        The flow log configuration attachment's `OCID`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param id: The id of this FlowLogConfigAttachment.
        :type: str
        """
        self._id = id

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this FlowLogConfigAttachment.
        The flow log configuration attachment's current state.

        Allowed values for this property are: "PROVISIONING", "AVAILABLE", "TERMINATING", "TERMINATED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this FlowLogConfigAttachment.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this FlowLogConfigAttachment.
        The flow log configuration attachment's current state.


        :param lifecycle_state: The lifecycle_state of this FlowLogConfigAttachment.
        :type: str
        """
        allowed_values = ["PROVISIONING", "AVAILABLE", "TERMINATING", "TERMINATED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def target_entity_id(self):
        """
        **[Required]** Gets the target_entity_id of this FlowLogConfigAttachment.
        The `OCID`__ of the resource that the flow log
        configuration is attached to.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The target_entity_id of this FlowLogConfigAttachment.
        :rtype: str
        """
        return self._target_entity_id

    @target_entity_id.setter
    def target_entity_id(self, target_entity_id):
        """
        Sets the target_entity_id of this FlowLogConfigAttachment.
        The `OCID`__ of the resource that the flow log
        configuration is attached to.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param target_entity_id: The target_entity_id of this FlowLogConfigAttachment.
        :type: str
        """
        self._target_entity_id = target_entity_id

    @property
    def target_entity_type(self):
        """
        **[Required]** Gets the target_entity_type of this FlowLogConfigAttachment.
        The type of resource that the flow log configuration is attached to.

        Allowed values for this property are: "SUBNET", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The target_entity_type of this FlowLogConfigAttachment.
        :rtype: str
        """
        return self._target_entity_type

    @target_entity_type.setter
    def target_entity_type(self, target_entity_type):
        """
        Sets the target_entity_type of this FlowLogConfigAttachment.
        The type of resource that the flow log configuration is attached to.


        :param target_entity_type: The target_entity_type of this FlowLogConfigAttachment.
        :type: str
        """
        allowed_values = ["SUBNET"]
        if not value_allowed_none_or_none_sentinel(target_entity_type, allowed_values):
            target_entity_type = 'UNKNOWN_ENUM_VALUE'
        self._target_entity_type = target_entity_type

    @property
    def flow_log_config_id(self):
        """
        **[Required]** Gets the flow_log_config_id of this FlowLogConfigAttachment.
        The `OCID`__ of the flow log configuration that
        is attached to the resource.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The flow_log_config_id of this FlowLogConfigAttachment.
        :rtype: str
        """
        return self._flow_log_config_id

    @flow_log_config_id.setter
    def flow_log_config_id(self, flow_log_config_id):
        """
        Sets the flow_log_config_id of this FlowLogConfigAttachment.
        The `OCID`__ of the flow log configuration that
        is attached to the resource.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param flow_log_config_id: The flow_log_config_id of this FlowLogConfigAttachment.
        :type: str
        """
        self._flow_log_config_id = flow_log_config_id

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this FlowLogConfigAttachment.
        The date and time the flow log configuration attachment was created, in the format defined by RFC3339.

        Example: `2016-08-25T21:10:29.600Z`


        :return: The time_created of this FlowLogConfigAttachment.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this FlowLogConfigAttachment.
        The date and time the flow log configuration attachment was created, in the format defined by RFC3339.

        Example: `2016-08-25T21:10:29.600Z`


        :param time_created: The time_created of this FlowLogConfigAttachment.
        :type: datetime
        """
        self._time_created = time_created

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
