# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.

from .flow_log_destination import FlowLogDestination
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class FlowLogObjectStorageDestination(FlowLogDestination):
    """
    Information to identify the Object Storage bucket where the flow logs will be stored.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new FlowLogObjectStorageDestination object with values from keyword arguments. The default value of the :py:attr:`~oci.core.models.FlowLogObjectStorageDestination.destination_type` attribute
        of this class is ``OBJECT_STORAGE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param destination_type:
            The value to assign to the destination_type property of this FlowLogObjectStorageDestination.
            Allowed values for this property are: "OBJECT_STORAGE"
        :type destination_type: str

        :param bucket_name:
            The value to assign to the bucket_name property of this FlowLogObjectStorageDestination.
        :type bucket_name: str

        :param namespace_name:
            The value to assign to the namespace_name property of this FlowLogObjectStorageDestination.
        :type namespace_name: str

        """
        self.swagger_types = {
            'destination_type': 'str',
            'bucket_name': 'str',
            'namespace_name': 'str'
        }

        self.attribute_map = {
            'destination_type': 'destinationType',
            'bucket_name': 'bucketName',
            'namespace_name': 'namespaceName'
        }

        self._destination_type = None
        self._bucket_name = None
        self._namespace_name = None
        self._destination_type = 'OBJECT_STORAGE'

    @property
    def bucket_name(self):
        """
        Gets the bucket_name of this FlowLogObjectStorageDestination.
        The Object Storage bucket name.


        :return: The bucket_name of this FlowLogObjectStorageDestination.
        :rtype: str
        """
        return self._bucket_name

    @bucket_name.setter
    def bucket_name(self, bucket_name):
        """
        Sets the bucket_name of this FlowLogObjectStorageDestination.
        The Object Storage bucket name.


        :param bucket_name: The bucket_name of this FlowLogObjectStorageDestination.
        :type: str
        """
        self._bucket_name = bucket_name

    @property
    def namespace_name(self):
        """
        Gets the namespace_name of this FlowLogObjectStorageDestination.
        The Object Storage namespace.


        :return: The namespace_name of this FlowLogObjectStorageDestination.
        :rtype: str
        """
        return self._namespace_name

    @namespace_name.setter
    def namespace_name(self, namespace_name):
        """
        Sets the namespace_name of this FlowLogObjectStorageDestination.
        The Object Storage namespace.


        :param namespace_name: The namespace_name of this FlowLogObjectStorageDestination.
        :type: str
        """
        self._namespace_name = namespace_name

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
