# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class GetCreateReverseConnectionNatIpDetails(object):
    """
    Details for retrieving reverse connection NAT IP address
    """

    def __init__(self, **kwargs):
        """
        Initializes a new GetCreateReverseConnectionNatIpDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param reverse_connection_customer_ip:
            The value to assign to the reverse_connection_customer_ip property of this GetCreateReverseConnectionNatIpDetails.
        :type reverse_connection_customer_ip: str

        """
        self.swagger_types = {
            'reverse_connection_customer_ip': 'str'
        }

        self.attribute_map = {
            'reverse_connection_customer_ip': 'reverseConnectionCustomerIp'
        }

        self._reverse_connection_customer_ip = None

    @property
    def reverse_connection_customer_ip(self):
        """
        **[Required]** Gets the reverse_connection_customer_ip of this GetCreateReverseConnectionNatIpDetails.
        Customer's IP address to which the reverse connection is going to be established.


        :return: The reverse_connection_customer_ip of this GetCreateReverseConnectionNatIpDetails.
        :rtype: str
        """
        return self._reverse_connection_customer_ip

    @reverse_connection_customer_ip.setter
    def reverse_connection_customer_ip(self, reverse_connection_customer_ip):
        """
        Sets the reverse_connection_customer_ip of this GetCreateReverseConnectionNatIpDetails.
        Customer's IP address to which the reverse connection is going to be established.


        :param reverse_connection_customer_ip: The reverse_connection_customer_ip of this GetCreateReverseConnectionNatIpDetails.
        :type: str
        """
        self._reverse_connection_customer_ip = reverse_connection_customer_ip

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
