# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class LaunchInstanceDetails(object):
    """
    Instance launch details.
    Use the `sourceDetails` parameter to specify whether a boot volume or an image should be used to launch a new instance.
    """

    #: A constant which can be used with the preferred_maintenance_action property of a LaunchInstanceDetails.
    #: This constant has a value of "LIVE_MIGRATE"
    PREFERRED_MAINTENANCE_ACTION_LIVE_MIGRATE = "LIVE_MIGRATE"

    #: A constant which can be used with the preferred_maintenance_action property of a LaunchInstanceDetails.
    #: This constant has a value of "REBOOT"
    PREFERRED_MAINTENANCE_ACTION_REBOOT = "REBOOT"

    def __init__(self, **kwargs):
        """
        Initializes a new LaunchInstanceDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param availability_domain:
            The value to assign to the availability_domain property of this LaunchInstanceDetails.
        :type availability_domain: str

        :param compartment_id:
            The value to assign to the compartment_id property of this LaunchInstanceDetails.
        :type compartment_id: str

        :param create_vnic_details:
            The value to assign to the create_vnic_details property of this LaunchInstanceDetails.
        :type create_vnic_details: CreateVnicDetails

        :param dedicated_vm_host_id:
            The value to assign to the dedicated_vm_host_id property of this LaunchInstanceDetails.
        :type dedicated_vm_host_id: str

        :param defined_tags:
            The value to assign to the defined_tags property of this LaunchInstanceDetails.
        :type defined_tags: dict(str, dict(str, object))

        :param display_name:
            The value to assign to the display_name property of this LaunchInstanceDetails.
        :type display_name: str

        :param extended_metadata:
            The value to assign to the extended_metadata property of this LaunchInstanceDetails.
        :type extended_metadata: dict(str, object)

        :param fault_domain:
            The value to assign to the fault_domain property of this LaunchInstanceDetails.
        :type fault_domain: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this LaunchInstanceDetails.
        :type freeform_tags: dict(str, str)

        :param hostname_label:
            The value to assign to the hostname_label property of this LaunchInstanceDetails.
        :type hostname_label: str

        :param image_id:
            The value to assign to the image_id property of this LaunchInstanceDetails.
        :type image_id: str

        :param ipxe_script:
            The value to assign to the ipxe_script property of this LaunchInstanceDetails.
        :type ipxe_script: str

        :param launch_options:
            The value to assign to the launch_options property of this LaunchInstanceDetails.
        :type launch_options: LaunchOptions

        :param metadata:
            The value to assign to the metadata property of this LaunchInstanceDetails.
        :type metadata: dict(str, str)

        :param agent_config:
            The value to assign to the agent_config property of this LaunchInstanceDetails.
        :type agent_config: LaunchInstanceAgentConfigDetails

        :param shape:
            The value to assign to the shape property of this LaunchInstanceDetails.
        :type shape: str

        :param shape_config:
            The value to assign to the shape_config property of this LaunchInstanceDetails.
        :type shape_config: LaunchInstanceShapeConfigDetails

        :param source_details:
            The value to assign to the source_details property of this LaunchInstanceDetails.
        :type source_details: InstanceSourceDetails

        :param subnet_id:
            The value to assign to the subnet_id property of this LaunchInstanceDetails.
        :type subnet_id: str

        :param volume_attachments:
            The value to assign to the volume_attachments property of this LaunchInstanceDetails.
        :type volume_attachments: list[AttachVolumeDetails]

        :param secondary_vnic_attachments:
            The value to assign to the secondary_vnic_attachments property of this LaunchInstanceDetails.
        :type secondary_vnic_attachments: list[AttachVnicDetails]

        :param is_pv_encryption_in_transit_enabled:
            The value to assign to the is_pv_encryption_in_transit_enabled property of this LaunchInstanceDetails.
        :type is_pv_encryption_in_transit_enabled: bool

        :param preferred_maintenance_action:
            The value to assign to the preferred_maintenance_action property of this LaunchInstanceDetails.
            Allowed values for this property are: "LIVE_MIGRATE", "REBOOT"
        :type preferred_maintenance_action: str

        """
        self.swagger_types = {
            'availability_domain': 'str',
            'compartment_id': 'str',
            'create_vnic_details': 'CreateVnicDetails',
            'dedicated_vm_host_id': 'str',
            'defined_tags': 'dict(str, dict(str, object))',
            'display_name': 'str',
            'extended_metadata': 'dict(str, object)',
            'fault_domain': 'str',
            'freeform_tags': 'dict(str, str)',
            'hostname_label': 'str',
            'image_id': 'str',
            'ipxe_script': 'str',
            'launch_options': 'LaunchOptions',
            'metadata': 'dict(str, str)',
            'agent_config': 'LaunchInstanceAgentConfigDetails',
            'shape': 'str',
            'shape_config': 'LaunchInstanceShapeConfigDetails',
            'source_details': 'InstanceSourceDetails',
            'subnet_id': 'str',
            'volume_attachments': 'list[AttachVolumeDetails]',
            'secondary_vnic_attachments': 'list[AttachVnicDetails]',
            'is_pv_encryption_in_transit_enabled': 'bool',
            'preferred_maintenance_action': 'str'
        }

        self.attribute_map = {
            'availability_domain': 'availabilityDomain',
            'compartment_id': 'compartmentId',
            'create_vnic_details': 'createVnicDetails',
            'dedicated_vm_host_id': 'dedicatedVmHostId',
            'defined_tags': 'definedTags',
            'display_name': 'displayName',
            'extended_metadata': 'extendedMetadata',
            'fault_domain': 'faultDomain',
            'freeform_tags': 'freeformTags',
            'hostname_label': 'hostnameLabel',
            'image_id': 'imageId',
            'ipxe_script': 'ipxeScript',
            'launch_options': 'launchOptions',
            'metadata': 'metadata',
            'agent_config': 'agentConfig',
            'shape': 'shape',
            'shape_config': 'shapeConfig',
            'source_details': 'sourceDetails',
            'subnet_id': 'subnetId',
            'volume_attachments': 'volumeAttachments',
            'secondary_vnic_attachments': 'secondaryVnicAttachments',
            'is_pv_encryption_in_transit_enabled': 'isPvEncryptionInTransitEnabled',
            'preferred_maintenance_action': 'preferredMaintenanceAction'
        }

        self._availability_domain = None
        self._compartment_id = None
        self._create_vnic_details = None
        self._dedicated_vm_host_id = None
        self._defined_tags = None
        self._display_name = None
        self._extended_metadata = None
        self._fault_domain = None
        self._freeform_tags = None
        self._hostname_label = None
        self._image_id = None
        self._ipxe_script = None
        self._launch_options = None
        self._metadata = None
        self._agent_config = None
        self._shape = None
        self._shape_config = None
        self._source_details = None
        self._subnet_id = None
        self._volume_attachments = None
        self._secondary_vnic_attachments = None
        self._is_pv_encryption_in_transit_enabled = None
        self._preferred_maintenance_action = None

    @property
    def availability_domain(self):
        """
        **[Required]** Gets the availability_domain of this LaunchInstanceDetails.
        The availability domain of the instance.

        Example: `Uocm:PHX-AD-1`


        :return: The availability_domain of this LaunchInstanceDetails.
        :rtype: str
        """
        return self._availability_domain

    @availability_domain.setter
    def availability_domain(self, availability_domain):
        """
        Sets the availability_domain of this LaunchInstanceDetails.
        The availability domain of the instance.

        Example: `Uocm:PHX-AD-1`


        :param availability_domain: The availability_domain of this LaunchInstanceDetails.
        :type: str
        """
        self._availability_domain = availability_domain

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this LaunchInstanceDetails.
        The OCID of the compartment.


        :return: The compartment_id of this LaunchInstanceDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this LaunchInstanceDetails.
        The OCID of the compartment.


        :param compartment_id: The compartment_id of this LaunchInstanceDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def create_vnic_details(self):
        """
        Gets the create_vnic_details of this LaunchInstanceDetails.
        Details for the primary VNIC, which is automatically created and attached when
        the instance is launched.


        :return: The create_vnic_details of this LaunchInstanceDetails.
        :rtype: CreateVnicDetails
        """
        return self._create_vnic_details

    @create_vnic_details.setter
    def create_vnic_details(self, create_vnic_details):
        """
        Sets the create_vnic_details of this LaunchInstanceDetails.
        Details for the primary VNIC, which is automatically created and attached when
        the instance is launched.


        :param create_vnic_details: The create_vnic_details of this LaunchInstanceDetails.
        :type: CreateVnicDetails
        """
        self._create_vnic_details = create_vnic_details

    @property
    def dedicated_vm_host_id(self):
        """
        Gets the dedicated_vm_host_id of this LaunchInstanceDetails.
        The OCID of dedicated VM host.


        :return: The dedicated_vm_host_id of this LaunchInstanceDetails.
        :rtype: str
        """
        return self._dedicated_vm_host_id

    @dedicated_vm_host_id.setter
    def dedicated_vm_host_id(self, dedicated_vm_host_id):
        """
        Sets the dedicated_vm_host_id of this LaunchInstanceDetails.
        The OCID of dedicated VM host.


        :param dedicated_vm_host_id: The dedicated_vm_host_id of this LaunchInstanceDetails.
        :type: str
        """
        self._dedicated_vm_host_id = dedicated_vm_host_id

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this LaunchInstanceDetails.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this LaunchInstanceDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this LaunchInstanceDetails.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this LaunchInstanceDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def display_name(self):
        """
        Gets the display_name of this LaunchInstanceDetails.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.

        Example: `My bare metal instance`


        :return: The display_name of this LaunchInstanceDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this LaunchInstanceDetails.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.

        Example: `My bare metal instance`


        :param display_name: The display_name of this LaunchInstanceDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def extended_metadata(self):
        """
        Gets the extended_metadata of this LaunchInstanceDetails.
        Additional metadata key/value pairs that you provide. They serve the same purpose and functionality as fields in the 'metadata' object.

        They are distinguished from 'metadata' fields in that these can be nested JSON objects (whereas 'metadata' fields are string/string maps only).


        :return: The extended_metadata of this LaunchInstanceDetails.
        :rtype: dict(str, object)
        """
        return self._extended_metadata

    @extended_metadata.setter
    def extended_metadata(self, extended_metadata):
        """
        Sets the extended_metadata of this LaunchInstanceDetails.
        Additional metadata key/value pairs that you provide. They serve the same purpose and functionality as fields in the 'metadata' object.

        They are distinguished from 'metadata' fields in that these can be nested JSON objects (whereas 'metadata' fields are string/string maps only).


        :param extended_metadata: The extended_metadata of this LaunchInstanceDetails.
        :type: dict(str, object)
        """
        self._extended_metadata = extended_metadata

    @property
    def fault_domain(self):
        """
        Gets the fault_domain of this LaunchInstanceDetails.
        A fault domain is a grouping of hardware and infrastructure within an availability domain.
        Each availability domain contains three fault domains. Fault domains let you distribute your
        instances so that they are not on the same physical hardware within a single availability domain.
        A hardware failure or Compute hardware maintenance that affects one fault domain does not affect
        instances in other fault domains.

        If you do not specify the fault domain, the system selects one for you. To change the fault
        domain for an instance, terminate it and launch a new instance in the preferred fault domain.

        To get a list of fault domains, use the
        :func:`list_fault_domains` operation in the
        Identity and Access Management Service API.

        Example: `FAULT-DOMAIN-1`


        :return: The fault_domain of this LaunchInstanceDetails.
        :rtype: str
        """
        return self._fault_domain

    @fault_domain.setter
    def fault_domain(self, fault_domain):
        """
        Sets the fault_domain of this LaunchInstanceDetails.
        A fault domain is a grouping of hardware and infrastructure within an availability domain.
        Each availability domain contains three fault domains. Fault domains let you distribute your
        instances so that they are not on the same physical hardware within a single availability domain.
        A hardware failure or Compute hardware maintenance that affects one fault domain does not affect
        instances in other fault domains.

        If you do not specify the fault domain, the system selects one for you. To change the fault
        domain for an instance, terminate it and launch a new instance in the preferred fault domain.

        To get a list of fault domains, use the
        :func:`list_fault_domains` operation in the
        Identity and Access Management Service API.

        Example: `FAULT-DOMAIN-1`


        :param fault_domain: The fault_domain of this LaunchInstanceDetails.
        :type: str
        """
        self._fault_domain = fault_domain

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this LaunchInstanceDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this LaunchInstanceDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this LaunchInstanceDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this LaunchInstanceDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def hostname_label(self):
        """
        Gets the hostname_label of this LaunchInstanceDetails.
        Deprecated. Instead use `hostnameLabel` in
        :class:`CreateVnicDetails`.
        If you provide both, the values must match.


        :return: The hostname_label of this LaunchInstanceDetails.
        :rtype: str
        """
        return self._hostname_label

    @hostname_label.setter
    def hostname_label(self, hostname_label):
        """
        Sets the hostname_label of this LaunchInstanceDetails.
        Deprecated. Instead use `hostnameLabel` in
        :class:`CreateVnicDetails`.
        If you provide both, the values must match.


        :param hostname_label: The hostname_label of this LaunchInstanceDetails.
        :type: str
        """
        self._hostname_label = hostname_label

    @property
    def image_id(self):
        """
        Gets the image_id of this LaunchInstanceDetails.
        Deprecated. Use `sourceDetails` with :func:`instance_source_via_image_details`
        source type instead. If you specify values for both, the values must match.


        :return: The image_id of this LaunchInstanceDetails.
        :rtype: str
        """
        return self._image_id

    @image_id.setter
    def image_id(self, image_id):
        """
        Sets the image_id of this LaunchInstanceDetails.
        Deprecated. Use `sourceDetails` with :func:`instance_source_via_image_details`
        source type instead. If you specify values for both, the values must match.


        :param image_id: The image_id of this LaunchInstanceDetails.
        :type: str
        """
        self._image_id = image_id

    @property
    def ipxe_script(self):
        """
        Gets the ipxe_script of this LaunchInstanceDetails.
        This is an advanced option.

        When a bare metal or virtual machine
        instance boots, the iPXE firmware that runs on the instance is
        configured to run an iPXE script to continue the boot process.

        If you want more control over the boot process, you can provide
        your own custom iPXE script that will run when the instance boots;
        however, you should be aware that the same iPXE script will run
        every time an instance boots; not only after the initial
        LaunchInstance call.

        The default iPXE script connects to the instance's local boot
        volume over iSCSI and performs a network boot. If you use a custom iPXE
        script and want to network-boot from the instance's local boot volume
        over iSCSI the same way as the default iPXE script, you should use the
        following iSCSI IP address: 169.254.0.2, and boot volume IQN:
        iqn.2015-02.oracle.boot.

        For more information about the Bring Your Own Image feature of
        Oracle Cloud Infrastructure, see
        `Bring Your Own Image`__.

        For more information about iPXE, see http://ipxe.org.

        __ https://docs.cloud.oracle.com/Content/Compute/References/bringyourownimage.htm


        :return: The ipxe_script of this LaunchInstanceDetails.
        :rtype: str
        """
        return self._ipxe_script

    @ipxe_script.setter
    def ipxe_script(self, ipxe_script):
        """
        Sets the ipxe_script of this LaunchInstanceDetails.
        This is an advanced option.

        When a bare metal or virtual machine
        instance boots, the iPXE firmware that runs on the instance is
        configured to run an iPXE script to continue the boot process.

        If you want more control over the boot process, you can provide
        your own custom iPXE script that will run when the instance boots;
        however, you should be aware that the same iPXE script will run
        every time an instance boots; not only after the initial
        LaunchInstance call.

        The default iPXE script connects to the instance's local boot
        volume over iSCSI and performs a network boot. If you use a custom iPXE
        script and want to network-boot from the instance's local boot volume
        over iSCSI the same way as the default iPXE script, you should use the
        following iSCSI IP address: 169.254.0.2, and boot volume IQN:
        iqn.2015-02.oracle.boot.

        For more information about the Bring Your Own Image feature of
        Oracle Cloud Infrastructure, see
        `Bring Your Own Image`__.

        For more information about iPXE, see http://ipxe.org.

        __ https://docs.cloud.oracle.com/Content/Compute/References/bringyourownimage.htm


        :param ipxe_script: The ipxe_script of this LaunchInstanceDetails.
        :type: str
        """
        self._ipxe_script = ipxe_script

    @property
    def launch_options(self):
        """
        Gets the launch_options of this LaunchInstanceDetails.

        :return: The launch_options of this LaunchInstanceDetails.
        :rtype: LaunchOptions
        """
        return self._launch_options

    @launch_options.setter
    def launch_options(self, launch_options):
        """
        Sets the launch_options of this LaunchInstanceDetails.

        :param launch_options: The launch_options of this LaunchInstanceDetails.
        :type: LaunchOptions
        """
        self._launch_options = launch_options

    @property
    def metadata(self):
        """
        Gets the metadata of this LaunchInstanceDetails.
        Custom metadata key/value pairs that you provide, such as the SSH public key
        required to connect to the instance.

        A metadata service runs on every launched instance. The service is an HTTP
        endpoint listening on 169.254.169.254. You can use the service to:

        * Provide information to `Cloud-Init`__
          to be used for various system initialization tasks.

        * Get information about the instance, including the custom metadata that you
          provide when you launch the instance.

         **Providing Cloud-Init Metadata**

         You can use the following metadata key names to provide information to
         Cloud-Init:

         **\"ssh_authorized_keys\"** - Provide one or more public SSH keys to be
         included in the `~/.ssh/authorized_keys` file for the default user on the
         instance. Use a newline character to separate multiple keys. The SSH
         keys must be in the format necessary for the `authorized_keys` file, as shown
         in the example below.

         **\"user_data\"** - Provide your own base64-encoded data to be used by
         Cloud-Init to run custom scripts or provide custom Cloud-Init configuration. For
         information about how to take advantage of user data, see the
         `Cloud-Init Documentation`__.

         **Note:** Cloud-Init does not pull this data from the `http://169.254.169.254/opc/v1/instance/metadata/`
         path. When the instance launches and either of these keys are provided, the key values are formatted as
         OpenStack metadata and copied to the following locations, which are recognized by Cloud-Init:

         `http://169.254.169.254/openstack/latest/meta_data.json` - This JSON blob
         contains, among other things, the SSH keys that you provided for
          **\"ssh_authorized_keys\"**.

         `http://169.254.169.254/openstack/latest/user_data` - Contains the
         base64-decoded data that you provided for **\"user_data\"**.

         **Metadata Example**

              \"metadata\" : {
                 \"quake_bot_level\" : \"Severe\",
                 \"ssh_authorized_keys\" : \"ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAACAQCZ06fccNTQfq+xubFlJ5ZR3kt+uzspdH9tXL+lAejSM1NXM+CFZev7MIxfEjas06y80ZBZ7DUTQO0GxJPeD8NCOb1VorF8M4xuLwrmzRtkoZzU16umt4y1W0Q4ifdp3IiiU0U8/WxczSXcUVZOLqkz5dc6oMHdMVpkimietWzGZ4LBBsH/LjEVY7E0V+a0sNchlVDIZcm7ErReBLcdTGDq0uLBiuChyl6RUkX1PNhusquTGwK7zc8OBXkRuubn5UKXhI3Ul9Nyk4XESkVWIGNKmw8mSpoJSjR8P9ZjRmcZVo8S+x4KVPMZKQEor== ryan.smith@company.com
                 ssh-rsa AAAAB3NzaC1yc2EAAAABJQAAAQEAzJSAtwEPoB3Jmr58IXrDGzLuDYkWAYg8AsLYlo6JZvKpjY1xednIcfEVQJm4T2DhVmdWhRrwQ8DmayVZvBkLt+zs2LdoAJEVimKwXcJFD/7wtH8Lnk17HiglbbbNXsemjDY0hea4JUE5CfvkIdZBITuMrfqSmA4n3VNoorXYdvtTMoGG8fxMub46RPtuxtqi9bG9Zqenordkg5FJt2mVNfQRqf83CWojcOkklUWq4CjyxaeLf5i9gv1fRoBo4QhiA8I6NCSppO8GnoV/6Ox6TNoh9BiifqGKC9VGYuC89RvUajRBTZSK2TK4DPfaT+2R+slPsFrwiT/oPEhhEK1S5Q== rsa-key-20160227\",
                 \"user_data\" : \"SWYgeW91IGNhbiBzZWUgdGhpcywgdGhlbiBpdCB3b3JrZWQgbWF5YmUuCg==\"
              }
         **Getting Metadata on the Instance**

         To get information about your instance, connect to the instance using SSH and issue any of the
         following GET requests:

             curl http://169.254.169.254/opc/v1/instance/
             curl http://169.254.169.254/opc/v1/instance/metadata/
             curl http://169.254.169.254/opc/v1/instance/metadata/<any-key-name>

         You'll get back a response that includes all the instance information; only the metadata information; or
         the metadata information for the specified key name, respectively.

        __ https://cloudinit.readthedocs.org/en/latest/
        __ http://cloudinit.readthedocs.org/en/latest/topics/format.html


        :return: The metadata of this LaunchInstanceDetails.
        :rtype: dict(str, str)
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata):
        """
        Sets the metadata of this LaunchInstanceDetails.
        Custom metadata key/value pairs that you provide, such as the SSH public key
        required to connect to the instance.

        A metadata service runs on every launched instance. The service is an HTTP
        endpoint listening on 169.254.169.254. You can use the service to:

        * Provide information to `Cloud-Init`__
          to be used for various system initialization tasks.

        * Get information about the instance, including the custom metadata that you
          provide when you launch the instance.

         **Providing Cloud-Init Metadata**

         You can use the following metadata key names to provide information to
         Cloud-Init:

         **\"ssh_authorized_keys\"** - Provide one or more public SSH keys to be
         included in the `~/.ssh/authorized_keys` file for the default user on the
         instance. Use a newline character to separate multiple keys. The SSH
         keys must be in the format necessary for the `authorized_keys` file, as shown
         in the example below.

         **\"user_data\"** - Provide your own base64-encoded data to be used by
         Cloud-Init to run custom scripts or provide custom Cloud-Init configuration. For
         information about how to take advantage of user data, see the
         `Cloud-Init Documentation`__.

         **Note:** Cloud-Init does not pull this data from the `http://169.254.169.254/opc/v1/instance/metadata/`
         path. When the instance launches and either of these keys are provided, the key values are formatted as
         OpenStack metadata and copied to the following locations, which are recognized by Cloud-Init:

         `http://169.254.169.254/openstack/latest/meta_data.json` - This JSON blob
         contains, among other things, the SSH keys that you provided for
          **\"ssh_authorized_keys\"**.

         `http://169.254.169.254/openstack/latest/user_data` - Contains the
         base64-decoded data that you provided for **\"user_data\"**.

         **Metadata Example**

              \"metadata\" : {
                 \"quake_bot_level\" : \"Severe\",
                 \"ssh_authorized_keys\" : \"ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAACAQCZ06fccNTQfq+xubFlJ5ZR3kt+uzspdH9tXL+lAejSM1NXM+CFZev7MIxfEjas06y80ZBZ7DUTQO0GxJPeD8NCOb1VorF8M4xuLwrmzRtkoZzU16umt4y1W0Q4ifdp3IiiU0U8/WxczSXcUVZOLqkz5dc6oMHdMVpkimietWzGZ4LBBsH/LjEVY7E0V+a0sNchlVDIZcm7ErReBLcdTGDq0uLBiuChyl6RUkX1PNhusquTGwK7zc8OBXkRuubn5UKXhI3Ul9Nyk4XESkVWIGNKmw8mSpoJSjR8P9ZjRmcZVo8S+x4KVPMZKQEor== ryan.smith@company.com
                 ssh-rsa AAAAB3NzaC1yc2EAAAABJQAAAQEAzJSAtwEPoB3Jmr58IXrDGzLuDYkWAYg8AsLYlo6JZvKpjY1xednIcfEVQJm4T2DhVmdWhRrwQ8DmayVZvBkLt+zs2LdoAJEVimKwXcJFD/7wtH8Lnk17HiglbbbNXsemjDY0hea4JUE5CfvkIdZBITuMrfqSmA4n3VNoorXYdvtTMoGG8fxMub46RPtuxtqi9bG9Zqenordkg5FJt2mVNfQRqf83CWojcOkklUWq4CjyxaeLf5i9gv1fRoBo4QhiA8I6NCSppO8GnoV/6Ox6TNoh9BiifqGKC9VGYuC89RvUajRBTZSK2TK4DPfaT+2R+slPsFrwiT/oPEhhEK1S5Q== rsa-key-20160227\",
                 \"user_data\" : \"SWYgeW91IGNhbiBzZWUgdGhpcywgdGhlbiBpdCB3b3JrZWQgbWF5YmUuCg==\"
              }
         **Getting Metadata on the Instance**

         To get information about your instance, connect to the instance using SSH and issue any of the
         following GET requests:

             curl http://169.254.169.254/opc/v1/instance/
             curl http://169.254.169.254/opc/v1/instance/metadata/
             curl http://169.254.169.254/opc/v1/instance/metadata/<any-key-name>

         You'll get back a response that includes all the instance information; only the metadata information; or
         the metadata information for the specified key name, respectively.

        __ https://cloudinit.readthedocs.org/en/latest/
        __ http://cloudinit.readthedocs.org/en/latest/topics/format.html


        :param metadata: The metadata of this LaunchInstanceDetails.
        :type: dict(str, str)
        """
        self._metadata = metadata

    @property
    def agent_config(self):
        """
        Gets the agent_config of this LaunchInstanceDetails.

        :return: The agent_config of this LaunchInstanceDetails.
        :rtype: LaunchInstanceAgentConfigDetails
        """
        return self._agent_config

    @agent_config.setter
    def agent_config(self, agent_config):
        """
        Sets the agent_config of this LaunchInstanceDetails.

        :param agent_config: The agent_config of this LaunchInstanceDetails.
        :type: LaunchInstanceAgentConfigDetails
        """
        self._agent_config = agent_config

    @property
    def shape(self):
        """
        **[Required]** Gets the shape of this LaunchInstanceDetails.
        The shape of an instance. The shape determines the number of CPUs, amount of memory,
        and other resources allocated to the instance.

        You can enumerate all available shapes by calling :func:`list_shapes`.


        :return: The shape of this LaunchInstanceDetails.
        :rtype: str
        """
        return self._shape

    @shape.setter
    def shape(self, shape):
        """
        Sets the shape of this LaunchInstanceDetails.
        The shape of an instance. The shape determines the number of CPUs, amount of memory,
        and other resources allocated to the instance.

        You can enumerate all available shapes by calling :func:`list_shapes`.


        :param shape: The shape of this LaunchInstanceDetails.
        :type: str
        """
        self._shape = shape

    @property
    def shape_config(self):
        """
        Gets the shape_config of this LaunchInstanceDetails.

        :return: The shape_config of this LaunchInstanceDetails.
        :rtype: LaunchInstanceShapeConfigDetails
        """
        return self._shape_config

    @shape_config.setter
    def shape_config(self, shape_config):
        """
        Sets the shape_config of this LaunchInstanceDetails.

        :param shape_config: The shape_config of this LaunchInstanceDetails.
        :type: LaunchInstanceShapeConfigDetails
        """
        self._shape_config = shape_config

    @property
    def source_details(self):
        """
        Gets the source_details of this LaunchInstanceDetails.
        Details for creating an instance.
        Use this parameter to specify whether a boot volume or an image should be used to launch a new instance.


        :return: The source_details of this LaunchInstanceDetails.
        :rtype: InstanceSourceDetails
        """
        return self._source_details

    @source_details.setter
    def source_details(self, source_details):
        """
        Sets the source_details of this LaunchInstanceDetails.
        Details for creating an instance.
        Use this parameter to specify whether a boot volume or an image should be used to launch a new instance.


        :param source_details: The source_details of this LaunchInstanceDetails.
        :type: InstanceSourceDetails
        """
        self._source_details = source_details

    @property
    def subnet_id(self):
        """
        Gets the subnet_id of this LaunchInstanceDetails.
        Deprecated. Instead use `subnetId` in
        :class:`CreateVnicDetails`.
        At least one of them is required; if you provide both, the values must match.


        :return: The subnet_id of this LaunchInstanceDetails.
        :rtype: str
        """
        return self._subnet_id

    @subnet_id.setter
    def subnet_id(self, subnet_id):
        """
        Sets the subnet_id of this LaunchInstanceDetails.
        Deprecated. Instead use `subnetId` in
        :class:`CreateVnicDetails`.
        At least one of them is required; if you provide both, the values must match.


        :param subnet_id: The subnet_id of this LaunchInstanceDetails.
        :type: str
        """
        self._subnet_id = subnet_id

    @property
    def volume_attachments(self):
        """
        Gets the volume_attachments of this LaunchInstanceDetails.
        Volume attachments to create as part of the launch instance operation.


        :return: The volume_attachments of this LaunchInstanceDetails.
        :rtype: list[AttachVolumeDetails]
        """
        return self._volume_attachments

    @volume_attachments.setter
    def volume_attachments(self, volume_attachments):
        """
        Sets the volume_attachments of this LaunchInstanceDetails.
        Volume attachments to create as part of the launch instance operation.


        :param volume_attachments: The volume_attachments of this LaunchInstanceDetails.
        :type: list[AttachVolumeDetails]
        """
        self._volume_attachments = volume_attachments

    @property
    def secondary_vnic_attachments(self):
        """
        Gets the secondary_vnic_attachments of this LaunchInstanceDetails.
        Secondary VNICS to create and attach as part of the launch instance operation.


        :return: The secondary_vnic_attachments of this LaunchInstanceDetails.
        :rtype: list[AttachVnicDetails]
        """
        return self._secondary_vnic_attachments

    @secondary_vnic_attachments.setter
    def secondary_vnic_attachments(self, secondary_vnic_attachments):
        """
        Sets the secondary_vnic_attachments of this LaunchInstanceDetails.
        Secondary VNICS to create and attach as part of the launch instance operation.


        :param secondary_vnic_attachments: The secondary_vnic_attachments of this LaunchInstanceDetails.
        :type: list[AttachVnicDetails]
        """
        self._secondary_vnic_attachments = secondary_vnic_attachments

    @property
    def is_pv_encryption_in_transit_enabled(self):
        """
        Gets the is_pv_encryption_in_transit_enabled of this LaunchInstanceDetails.
        Whether to enable in-transit encryption for the data volume's paravirtualized attachment. The default value is false.


        :return: The is_pv_encryption_in_transit_enabled of this LaunchInstanceDetails.
        :rtype: bool
        """
        return self._is_pv_encryption_in_transit_enabled

    @is_pv_encryption_in_transit_enabled.setter
    def is_pv_encryption_in_transit_enabled(self, is_pv_encryption_in_transit_enabled):
        """
        Sets the is_pv_encryption_in_transit_enabled of this LaunchInstanceDetails.
        Whether to enable in-transit encryption for the data volume's paravirtualized attachment. The default value is false.


        :param is_pv_encryption_in_transit_enabled: The is_pv_encryption_in_transit_enabled of this LaunchInstanceDetails.
        :type: bool
        """
        self._is_pv_encryption_in_transit_enabled = is_pv_encryption_in_transit_enabled

    @property
    def preferred_maintenance_action(self):
        """
        Gets the preferred_maintenance_action of this LaunchInstanceDetails.
        The preferred maintenance action for an instance. The default is LIVE_MIGRATE, if live migration is supported.
        * `LIVE_MIGRATE` - Run maintenance using a live migration.
        * `REBOOT` - Run maintenance using a reboot.

        Allowed values for this property are: "LIVE_MIGRATE", "REBOOT"


        :return: The preferred_maintenance_action of this LaunchInstanceDetails.
        :rtype: str
        """
        return self._preferred_maintenance_action

    @preferred_maintenance_action.setter
    def preferred_maintenance_action(self, preferred_maintenance_action):
        """
        Sets the preferred_maintenance_action of this LaunchInstanceDetails.
        The preferred maintenance action for an instance. The default is LIVE_MIGRATE, if live migration is supported.
        * `LIVE_MIGRATE` - Run maintenance using a live migration.
        * `REBOOT` - Run maintenance using a reboot.


        :param preferred_maintenance_action: The preferred_maintenance_action of this LaunchInstanceDetails.
        :type: str
        """
        allowed_values = ["LIVE_MIGRATE", "REBOOT"]
        if not value_allowed_none_or_none_sentinel(preferred_maintenance_action, allowed_values):
            raise ValueError(
                "Invalid value for `preferred_maintenance_action`, must be None or one of {0}"
                .format(allowed_values)
            )
        self._preferred_maintenance_action = preferred_maintenance_action

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
