# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class LocalPeeringConnection(object):
    """
    Details regarding a local peering connection, which is an entity that allows two VCNs to communicate
    without traversing the Internet.

    To use any of the API operations, you must be authorized in an IAM policy. If you're not authorized,
    talk to an administrator. If you're an administrator who needs to write policies to give users access, see
    `Getting Started with Policies`__.

    **Warning:** Oracle recommends that you avoid using any confidential information when you
    supply string values using the API.

    __ https://docs.cloud.oracle.com/Content/Identity/Concepts/policygetstarted.htm
    """

    #: A constant which can be used with the lifecycle_state property of a LocalPeeringConnection.
    #: This constant has a value of "PROVISIONING"
    LIFECYCLE_STATE_PROVISIONING = "PROVISIONING"

    #: A constant which can be used with the lifecycle_state property of a LocalPeeringConnection.
    #: This constant has a value of "AVAILABLE"
    LIFECYCLE_STATE_AVAILABLE = "AVAILABLE"

    #: A constant which can be used with the lifecycle_state property of a LocalPeeringConnection.
    #: This constant has a value of "TERMINATING"
    LIFECYCLE_STATE_TERMINATING = "TERMINATING"

    #: A constant which can be used with the lifecycle_state property of a LocalPeeringConnection.
    #: This constant has a value of "TERMINATED"
    LIFECYCLE_STATE_TERMINATED = "TERMINATED"

    #: A constant which can be used with the peering_status property of a LocalPeeringConnection.
    #: This constant has a value of "INVALID"
    PEERING_STATUS_INVALID = "INVALID"

    #: A constant which can be used with the peering_status property of a LocalPeeringConnection.
    #: This constant has a value of "NEW"
    PEERING_STATUS_NEW = "NEW"

    #: A constant which can be used with the peering_status property of a LocalPeeringConnection.
    #: This constant has a value of "PEERED"
    PEERING_STATUS_PEERED = "PEERED"

    #: A constant which can be used with the peering_status property of a LocalPeeringConnection.
    #: This constant has a value of "PENDING"
    PEERING_STATUS_PENDING = "PENDING"

    #: A constant which can be used with the peering_status property of a LocalPeeringConnection.
    #: This constant has a value of "REVOKED"
    PEERING_STATUS_REVOKED = "REVOKED"

    def __init__(self, **kwargs):
        """
        Initializes a new LocalPeeringConnection object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this LocalPeeringConnection.
        :type compartment_id: str

        :param display_name:
            The value to assign to the display_name property of this LocalPeeringConnection.
        :type display_name: str

        :param id:
            The value to assign to the id property of this LocalPeeringConnection.
        :type id: str

        :param is_cross_tenancy_peering:
            The value to assign to the is_cross_tenancy_peering property of this LocalPeeringConnection.
        :type is_cross_tenancy_peering: bool

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this LocalPeeringConnection.
            Allowed values for this property are: "PROVISIONING", "AVAILABLE", "TERMINATING", "TERMINATED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param peer_advertised_cidr:
            The value to assign to the peer_advertised_cidr property of this LocalPeeringConnection.
        :type peer_advertised_cidr: str

        :param peering_status:
            The value to assign to the peering_status property of this LocalPeeringConnection.
            Allowed values for this property are: "INVALID", "NEW", "PEERED", "PENDING", "REVOKED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type peering_status: str

        :param peering_status_details:
            The value to assign to the peering_status_details property of this LocalPeeringConnection.
        :type peering_status_details: str

        :param time_created:
            The value to assign to the time_created property of this LocalPeeringConnection.
        :type time_created: datetime

        :param vcn_id:
            The value to assign to the vcn_id property of this LocalPeeringConnection.
        :type vcn_id: str

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'display_name': 'str',
            'id': 'str',
            'is_cross_tenancy_peering': 'bool',
            'lifecycle_state': 'str',
            'peer_advertised_cidr': 'str',
            'peering_status': 'str',
            'peering_status_details': 'str',
            'time_created': 'datetime',
            'vcn_id': 'str'
        }

        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'display_name': 'displayName',
            'id': 'id',
            'is_cross_tenancy_peering': 'isCrossTenancyPeering',
            'lifecycle_state': 'lifecycleState',
            'peer_advertised_cidr': 'peerAdvertisedCidr',
            'peering_status': 'peeringStatus',
            'peering_status_details': 'peeringStatusDetails',
            'time_created': 'timeCreated',
            'vcn_id': 'vcnId'
        }

        self._compartment_id = None
        self._display_name = None
        self._id = None
        self._is_cross_tenancy_peering = None
        self._lifecycle_state = None
        self._peer_advertised_cidr = None
        self._peering_status = None
        self._peering_status_details = None
        self._time_created = None
        self._vcn_id = None

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this LocalPeeringConnection.
        The OCID of the compartment containing the local peering connection.


        :return: The compartment_id of this LocalPeeringConnection.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this LocalPeeringConnection.
        The OCID of the compartment containing the local peering connection.


        :param compartment_id: The compartment_id of this LocalPeeringConnection.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this LocalPeeringConnection.
        A user-friendly name. Does not have to be unique, and it's changeable.


        :return: The display_name of this LocalPeeringConnection.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this LocalPeeringConnection.
        A user-friendly name. Does not have to be unique, and it's changeable.


        :param display_name: The display_name of this LocalPeeringConnection.
        :type: str
        """
        self._display_name = display_name

    @property
    def id(self):
        """
        **[Required]** Gets the id of this LocalPeeringConnection.
        The local peering connection's Oracle ID (OCID).


        :return: The id of this LocalPeeringConnection.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this LocalPeeringConnection.
        The local peering connection's Oracle ID (OCID).


        :param id: The id of this LocalPeeringConnection.
        :type: str
        """
        self._id = id

    @property
    def is_cross_tenancy_peering(self):
        """
        Gets the is_cross_tenancy_peering of this LocalPeeringConnection.
        Indicates whether the peer local peering connection is contained within another tenancy.


        :return: The is_cross_tenancy_peering of this LocalPeeringConnection.
        :rtype: bool
        """
        return self._is_cross_tenancy_peering

    @is_cross_tenancy_peering.setter
    def is_cross_tenancy_peering(self, is_cross_tenancy_peering):
        """
        Sets the is_cross_tenancy_peering of this LocalPeeringConnection.
        Indicates whether the peer local peering connection is contained within another tenancy.


        :param is_cross_tenancy_peering: The is_cross_tenancy_peering of this LocalPeeringConnection.
        :type: bool
        """
        self._is_cross_tenancy_peering = is_cross_tenancy_peering

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this LocalPeeringConnection.
        The local peering connection's current lifecycle state.

        Allowed values for this property are: "PROVISIONING", "AVAILABLE", "TERMINATING", "TERMINATED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this LocalPeeringConnection.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this LocalPeeringConnection.
        The local peering connection's current lifecycle state.


        :param lifecycle_state: The lifecycle_state of this LocalPeeringConnection.
        :type: str
        """
        allowed_values = ["PROVISIONING", "AVAILABLE", "TERMINATING", "TERMINATED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def peer_advertised_cidr(self):
        """
        Gets the peer_advertised_cidr of this LocalPeeringConnection.
        Indicates the range of IPs available on the peer. `null` if not peered.


        :return: The peer_advertised_cidr of this LocalPeeringConnection.
        :rtype: str
        """
        return self._peer_advertised_cidr

    @peer_advertised_cidr.setter
    def peer_advertised_cidr(self, peer_advertised_cidr):
        """
        Sets the peer_advertised_cidr of this LocalPeeringConnection.
        Indicates the range of IPs available on the peer. `null` if not peered.


        :param peer_advertised_cidr: The peer_advertised_cidr of this LocalPeeringConnection.
        :type: str
        """
        self._peer_advertised_cidr = peer_advertised_cidr

    @property
    def peering_status(self):
        """
        **[Required]** Gets the peering_status of this LocalPeeringConnection.
        Indicates whether the local peering connection is peered with another local peering connection.

        Allowed values for this property are: "INVALID", "NEW", "PEERED", "PENDING", "REVOKED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The peering_status of this LocalPeeringConnection.
        :rtype: str
        """
        return self._peering_status

    @peering_status.setter
    def peering_status(self, peering_status):
        """
        Sets the peering_status of this LocalPeeringConnection.
        Indicates whether the local peering connection is peered with another local peering connection.


        :param peering_status: The peering_status of this LocalPeeringConnection.
        :type: str
        """
        allowed_values = ["INVALID", "NEW", "PEERED", "PENDING", "REVOKED"]
        if not value_allowed_none_or_none_sentinel(peering_status, allowed_values):
            peering_status = 'UNKNOWN_ENUM_VALUE'
        self._peering_status = peering_status

    @property
    def peering_status_details(self):
        """
        Gets the peering_status_details of this LocalPeeringConnection.
        Additional information regarding the peering status if applicable.


        :return: The peering_status_details of this LocalPeeringConnection.
        :rtype: str
        """
        return self._peering_status_details

    @peering_status_details.setter
    def peering_status_details(self, peering_status_details):
        """
        Sets the peering_status_details of this LocalPeeringConnection.
        Additional information regarding the peering status if applicable.


        :param peering_status_details: The peering_status_details of this LocalPeeringConnection.
        :type: str
        """
        self._peering_status_details = peering_status_details

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this LocalPeeringConnection.
        The date and time the local peering connection was created, in the format defined by RFC3339.

        Example: `2016-08-25T21:10:29.600Z`


        :return: The time_created of this LocalPeeringConnection.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this LocalPeeringConnection.
        The date and time the local peering connection was created, in the format defined by RFC3339.

        Example: `2016-08-25T21:10:29.600Z`


        :param time_created: The time_created of this LocalPeeringConnection.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def vcn_id(self):
        """
        **[Required]** Gets the vcn_id of this LocalPeeringConnection.
        The OCID of the VCN the local peering connection belongs to.


        :return: The vcn_id of this LocalPeeringConnection.
        :rtype: str
        """
        return self._vcn_id

    @vcn_id.setter
    def vcn_id(self, vcn_id):
        """
        Sets the vcn_id of this LocalPeeringConnection.
        The OCID of the VCN the local peering connection belongs to.


        :param vcn_id: The vcn_id of this LocalPeeringConnection.
        :type: str
        """
        self._vcn_id = vcn_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
