# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class LocalPeeringTokenDetails(object):
    """
    An object containing a generated peering token to be given to a peer who then accepts the token as part of the peering handshake process.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new LocalPeeringTokenDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param token_for_peer:
            The value to assign to the token_for_peer property of this LocalPeeringTokenDetails.
        :type token_for_peer: str

        """
        self.swagger_types = {
            'token_for_peer': 'str'
        }

        self.attribute_map = {
            'token_for_peer': 'tokenForPeer'
        }

        self._token_for_peer = None

    @property
    def token_for_peer(self):
        """
        **[Required]** Gets the token_for_peer of this LocalPeeringTokenDetails.
        An opaque token to be shared with a peer.


        :return: The token_for_peer of this LocalPeeringTokenDetails.
        :rtype: str
        """
        return self._token_for_peer

    @token_for_peer.setter
    def token_for_peer(self, token_for_peer):
        """
        Sets the token_for_peer of this LocalPeeringTokenDetails.
        An opaque token to be shared with a peer.


        :param token_for_peer: The token_for_peer of this LocalPeeringTokenDetails.
        :type: str
        """
        self._token_for_peer = token_for_peer

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
