# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ModifyReverseConnectionsDetails(object):
    """
    Details for modifying reverse connections functionality on the Private Endpoint
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ModifyReverseConnectionsDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param excluded_dns_zones:
            The value to assign to the excluded_dns_zones property of this ModifyReverseConnectionsDetails.
        :type excluded_dns_zones: list[str]

        """
        self.swagger_types = {
            'excluded_dns_zones': 'list[str]'
        }

        self.attribute_map = {
            'excluded_dns_zones': 'excludedDnsZones'
        }

        self._excluded_dns_zones = None

    @property
    def excluded_dns_zones(self):
        """
        Gets the excluded_dns_zones of this ModifyReverseConnectionsDetails.
        List of DNS zones to exclude from the default DNS resolution context.


        :return: The excluded_dns_zones of this ModifyReverseConnectionsDetails.
        :rtype: list[str]
        """
        return self._excluded_dns_zones

    @excluded_dns_zones.setter
    def excluded_dns_zones(self, excluded_dns_zones):
        """
        Sets the excluded_dns_zones of this ModifyReverseConnectionsDetails.
        List of DNS zones to exclude from the default DNS resolution context.


        :param excluded_dns_zones: The excluded_dns_zones of this ModifyReverseConnectionsDetails.
        :type: list[str]
        """
        self._excluded_dns_zones = excluded_dns_zones

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
