# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PrivateAccessGatewaySummary(object):
    """
    A summary of private access gateway (PAG) information. This object is returned when listing
    PAGs.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new PrivateAccessGatewaySummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this PrivateAccessGatewaySummary.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this PrivateAccessGatewaySummary.
        :type display_name: str

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName'
        }

        self._id = None
        self._display_name = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this PrivateAccessGatewaySummary.
        The `OCID`__ of the PAG.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The id of this PrivateAccessGatewaySummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this PrivateAccessGatewaySummary.
        The `OCID`__ of the PAG.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param id: The id of this PrivateAccessGatewaySummary.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this PrivateAccessGatewaySummary.
        The PAG's friendly name.


        :return: The display_name of this PrivateAccessGatewaySummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this PrivateAccessGatewaySummary.
        The PAG's friendly name.


        :param display_name: The display_name of this PrivateAccessGatewaySummary.
        :type: str
        """
        self._display_name = display_name

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
