# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PrivateEndpointAssociation(object):
    """
    A summary of private endpoint information. This object is returned when listing the private
    endpoints associated with a given endpoint service.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new PrivateEndpointAssociation object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this PrivateEndpointAssociation.
        :type id: str

        :param private_endpoint_ip:
            The value to assign to the private_endpoint_ip property of this PrivateEndpointAssociation.
        :type private_endpoint_ip: str

        :param endpoint_fqdn:
            The value to assign to the endpoint_fqdn property of this PrivateEndpointAssociation.
        :type endpoint_fqdn: str

        :param reverse_connection_configuration:
            The value to assign to the reverse_connection_configuration property of this PrivateEndpointAssociation.
        :type reverse_connection_configuration: ReverseConnectionConfiguration

        """
        self.swagger_types = {
            'id': 'str',
            'private_endpoint_ip': 'str',
            'endpoint_fqdn': 'str',
            'reverse_connection_configuration': 'ReverseConnectionConfiguration'
        }

        self.attribute_map = {
            'id': 'id',
            'private_endpoint_ip': 'privateEndpointIp',
            'endpoint_fqdn': 'endpointFqdn',
            'reverse_connection_configuration': 'reverseConnectionConfiguration'
        }

        self._id = None
        self._private_endpoint_ip = None
        self._endpoint_fqdn = None
        self._reverse_connection_configuration = None

    @property
    def id(self):
        """
        Gets the id of this PrivateEndpointAssociation.
        The `OCID`__ of the private endpoint.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The id of this PrivateEndpointAssociation.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this PrivateEndpointAssociation.
        The `OCID`__ of the private endpoint.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param id: The id of this PrivateEndpointAssociation.
        :type: str
        """
        self._id = id

    @property
    def private_endpoint_ip(self):
        """
        Gets the private_endpoint_ip of this PrivateEndpointAssociation.
        The private IP address (in the customer's VCN) that represents the access point for the
        associated endpoint service.


        :return: The private_endpoint_ip of this PrivateEndpointAssociation.
        :rtype: str
        """
        return self._private_endpoint_ip

    @private_endpoint_ip.setter
    def private_endpoint_ip(self, private_endpoint_ip):
        """
        Sets the private_endpoint_ip of this PrivateEndpointAssociation.
        The private IP address (in the customer's VCN) that represents the access point for the
        associated endpoint service.


        :param private_endpoint_ip: The private_endpoint_ip of this PrivateEndpointAssociation.
        :type: str
        """
        self._private_endpoint_ip = private_endpoint_ip

    @property
    def endpoint_fqdn(self):
        """
        Gets the endpoint_fqdn of this PrivateEndpointAssociation.
        The three-label FQDN to use for the private endpoint. The customer VCN's DNS records use
        this FQDN.

        For important information about how this attribute is used, see the discussion
        of DNS and FQDNs in :class:`PrivateEndpoint`.

        Example: `xyz.oraclecloud.com`


        :return: The endpoint_fqdn of this PrivateEndpointAssociation.
        :rtype: str
        """
        return self._endpoint_fqdn

    @endpoint_fqdn.setter
    def endpoint_fqdn(self, endpoint_fqdn):
        """
        Sets the endpoint_fqdn of this PrivateEndpointAssociation.
        The three-label FQDN to use for the private endpoint. The customer VCN's DNS records use
        this FQDN.

        For important information about how this attribute is used, see the discussion
        of DNS and FQDNs in :class:`PrivateEndpoint`.

        Example: `xyz.oraclecloud.com`


        :param endpoint_fqdn: The endpoint_fqdn of this PrivateEndpointAssociation.
        :type: str
        """
        self._endpoint_fqdn = endpoint_fqdn

    @property
    def reverse_connection_configuration(self):
        """
        Gets the reverse_connection_configuration of this PrivateEndpointAssociation.

        :return: The reverse_connection_configuration of this PrivateEndpointAssociation.
        :rtype: ReverseConnectionConfiguration
        """
        return self._reverse_connection_configuration

    @reverse_connection_configuration.setter
    def reverse_connection_configuration(self, reverse_connection_configuration):
        """
        Sets the reverse_connection_configuration of this PrivateEndpointAssociation.

        :param reverse_connection_configuration: The reverse_connection_configuration of this PrivateEndpointAssociation.
        :type: ReverseConnectionConfiguration
        """
        self._reverse_connection_configuration = reverse_connection_configuration

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
