# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ReverseConnectionConfiguration(object):
    """
    Reverse Connections Configuration details for the Private Endpoint.
    When reverse connections functionality is enabled, the Private Endpoint can allow reverse connections to be established to the customer VCN.
    Reverse connections will use different source IP addresses than the Private Endpoints' IP address.
    """

    #: A constant which can be used with the lifecycle_state property of a ReverseConnectionConfiguration.
    #: This constant has a value of "PROVISIONING"
    LIFECYCLE_STATE_PROVISIONING = "PROVISIONING"

    #: A constant which can be used with the lifecycle_state property of a ReverseConnectionConfiguration.
    #: This constant has a value of "AVAILABLE"
    LIFECYCLE_STATE_AVAILABLE = "AVAILABLE"

    #: A constant which can be used with the lifecycle_state property of a ReverseConnectionConfiguration.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a ReverseConnectionConfiguration.
    #: This constant has a value of "TERMINATING"
    LIFECYCLE_STATE_TERMINATING = "TERMINATING"

    #: A constant which can be used with the lifecycle_state property of a ReverseConnectionConfiguration.
    #: This constant has a value of "TERMINATED"
    LIFECYCLE_STATE_TERMINATED = "TERMINATED"

    #: A constant which can be used with the lifecycle_state property of a ReverseConnectionConfiguration.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    #: A constant which can be used with the default_dns_resolution_context property of a ReverseConnectionConfiguration.
    #: This constant has a value of "SERVICE"
    DEFAULT_DNS_RESOLUTION_CONTEXT_SERVICE = "SERVICE"

    #: A constant which can be used with the default_dns_resolution_context property of a ReverseConnectionConfiguration.
    #: This constant has a value of "CUSTOMER"
    DEFAULT_DNS_RESOLUTION_CONTEXT_CUSTOMER = "CUSTOMER"

    def __init__(self, **kwargs):
        """
        Initializes a new ReverseConnectionConfiguration object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this ReverseConnectionConfiguration.
            Allowed values for this property are: "PROVISIONING", "AVAILABLE", "UPDATING", "TERMINATING", "TERMINATED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param reverse_connections_source_ips:
            The value to assign to the reverse_connections_source_ips property of this ReverseConnectionConfiguration.
        :type reverse_connections_source_ips: list[ReverseConnectionsSourceIpDetails]

        :param dns_proxy_ip:
            The value to assign to the dns_proxy_ip property of this ReverseConnectionConfiguration.
        :type dns_proxy_ip: str

        :param default_dns_resolution_context:
            The value to assign to the default_dns_resolution_context property of this ReverseConnectionConfiguration.
            Allowed values for this property are: "SERVICE", "CUSTOMER", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type default_dns_resolution_context: str

        :param excluded_dns_zones:
            The value to assign to the excluded_dns_zones property of this ReverseConnectionConfiguration.
        :type excluded_dns_zones: list[str]

        :param service_subnet_id:
            The value to assign to the service_subnet_id property of this ReverseConnectionConfiguration.
        :type service_subnet_id: str

        """
        self.swagger_types = {
            'lifecycle_state': 'str',
            'reverse_connections_source_ips': 'list[ReverseConnectionsSourceIpDetails]',
            'dns_proxy_ip': 'str',
            'default_dns_resolution_context': 'str',
            'excluded_dns_zones': 'list[str]',
            'service_subnet_id': 'str'
        }

        self.attribute_map = {
            'lifecycle_state': 'lifecycleState',
            'reverse_connections_source_ips': 'reverseConnectionsSourceIps',
            'dns_proxy_ip': 'dnsProxyIp',
            'default_dns_resolution_context': 'defaultDnsResolutionContext',
            'excluded_dns_zones': 'excludedDnsZones',
            'service_subnet_id': 'serviceSubnetId'
        }

        self._lifecycle_state = None
        self._reverse_connections_source_ips = None
        self._dns_proxy_ip = None
        self._default_dns_resolution_context = None
        self._excluded_dns_zones = None
        self._service_subnet_id = None

    @property
    def lifecycle_state(self):
        """
        Gets the lifecycle_state of this ReverseConnectionConfiguration.
        The Reverse Connections Configuration's current state.

        Allowed values for this property are: "PROVISIONING", "AVAILABLE", "UPDATING", "TERMINATING", "TERMINATED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this ReverseConnectionConfiguration.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this ReverseConnectionConfiguration.
        The Reverse Connections Configuration's current state.


        :param lifecycle_state: The lifecycle_state of this ReverseConnectionConfiguration.
        :type: str
        """
        allowed_values = ["PROVISIONING", "AVAILABLE", "UPDATING", "TERMINATING", "TERMINATED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def reverse_connections_source_ips(self):
        """
        Gets the reverse_connections_source_ips of this ReverseConnectionConfiguration.
        IP addresses in customer VCN which will be used as source IPs for reverse connections from the service provider's VCN to the customer VCN.


        :return: The reverse_connections_source_ips of this ReverseConnectionConfiguration.
        :rtype: list[ReverseConnectionsSourceIpDetails]
        """
        return self._reverse_connections_source_ips

    @reverse_connections_source_ips.setter
    def reverse_connections_source_ips(self, reverse_connections_source_ips):
        """
        Sets the reverse_connections_source_ips of this ReverseConnectionConfiguration.
        IP addresses in customer VCN which will be used as source IPs for reverse connections from the service provider's VCN to the customer VCN.


        :param reverse_connections_source_ips: The reverse_connections_source_ips of this ReverseConnectionConfiguration.
        :type: list[ReverseConnectionsSourceIpDetails]
        """
        self._reverse_connections_source_ips = reverse_connections_source_ips

    @property
    def dns_proxy_ip(self):
        """
        Gets the dns_proxy_ip of this ReverseConnectionConfiguration.
        IP address in service provider VCN that should be used as DNS proxy for resolving DNS FQDN to the destination IP addresses for reverse connections.


        :return: The dns_proxy_ip of this ReverseConnectionConfiguration.
        :rtype: str
        """
        return self._dns_proxy_ip

    @dns_proxy_ip.setter
    def dns_proxy_ip(self, dns_proxy_ip):
        """
        Sets the dns_proxy_ip of this ReverseConnectionConfiguration.
        IP address in service provider VCN that should be used as DNS proxy for resolving DNS FQDN to the destination IP addresses for reverse connections.


        :param dns_proxy_ip: The dns_proxy_ip of this ReverseConnectionConfiguration.
        :type: str
        """
        self._dns_proxy_ip = dns_proxy_ip

    @property
    def default_dns_resolution_context(self):
        """
        Gets the default_dns_resolution_context of this ReverseConnectionConfiguration.
        Context in which the DNS proxy will resolve the DNS queries in. The default is `SERVICE`.

        Allowed values:

         * `SERVICE` : All DNS queries will be resolved within the service VCN's DNS context, unless the FQDN belongs to one of zones in the `excludedDnsZones` list.

         * `CUSTOMER` : All DNS queries will be resolved within the customer VCN's DNS context, unless the FQDN belongs to one of zones in the `excludedDnsZones` list.

        Allowed values for this property are: "SERVICE", "CUSTOMER", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The default_dns_resolution_context of this ReverseConnectionConfiguration.
        :rtype: str
        """
        return self._default_dns_resolution_context

    @default_dns_resolution_context.setter
    def default_dns_resolution_context(self, default_dns_resolution_context):
        """
        Sets the default_dns_resolution_context of this ReverseConnectionConfiguration.
        Context in which the DNS proxy will resolve the DNS queries in. The default is `SERVICE`.

        Allowed values:

         * `SERVICE` : All DNS queries will be resolved within the service VCN's DNS context, unless the FQDN belongs to one of zones in the `excludedDnsZones` list.

         * `CUSTOMER` : All DNS queries will be resolved within the customer VCN's DNS context, unless the FQDN belongs to one of zones in the `excludedDnsZones` list.


        :param default_dns_resolution_context: The default_dns_resolution_context of this ReverseConnectionConfiguration.
        :type: str
        """
        allowed_values = ["SERVICE", "CUSTOMER"]
        if not value_allowed_none_or_none_sentinel(default_dns_resolution_context, allowed_values):
            default_dns_resolution_context = 'UNKNOWN_ENUM_VALUE'
        self._default_dns_resolution_context = default_dns_resolution_context

    @property
    def excluded_dns_zones(self):
        """
        Gets the excluded_dns_zones of this ReverseConnectionConfiguration.
        List of DNS zones to exclude from the default DNS resolution context.


        :return: The excluded_dns_zones of this ReverseConnectionConfiguration.
        :rtype: list[str]
        """
        return self._excluded_dns_zones

    @excluded_dns_zones.setter
    def excluded_dns_zones(self, excluded_dns_zones):
        """
        Sets the excluded_dns_zones of this ReverseConnectionConfiguration.
        List of DNS zones to exclude from the default DNS resolution context.


        :param excluded_dns_zones: The excluded_dns_zones of this ReverseConnectionConfiguration.
        :type: list[str]
        """
        self._excluded_dns_zones = excluded_dns_zones

    @property
    def service_subnet_id(self):
        """
        Gets the service_subnet_id of this ReverseConnectionConfiguration.
        The `OCID`__ of the service provider's subnet, in which DNS proxy endpoint will be spwaned.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The service_subnet_id of this ReverseConnectionConfiguration.
        :rtype: str
        """
        return self._service_subnet_id

    @service_subnet_id.setter
    def service_subnet_id(self, service_subnet_id):
        """
        Sets the service_subnet_id of this ReverseConnectionConfiguration.
        The `OCID`__ of the service provider's subnet, in which DNS proxy endpoint will be spwaned.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param service_subnet_id: The service_subnet_id of this ReverseConnectionConfiguration.
        :type: str
        """
        self._service_subnet_id = service_subnet_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
