# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ReverseConnectionNatIp(object):
    """
    Current allocation of NAT IP address for a specific customer IP address.
    For service providers to establish a reverse connection to a customer IP address,
    reverse connection NAT IP address should be used as the destination.
    """

    #: A constant which can be used with the lifecycle_state property of a ReverseConnectionNatIp.
    #: This constant has a value of "PROVISIONING"
    LIFECYCLE_STATE_PROVISIONING = "PROVISIONING"

    #: A constant which can be used with the lifecycle_state property of a ReverseConnectionNatIp.
    #: This constant has a value of "AVAILABLE"
    LIFECYCLE_STATE_AVAILABLE = "AVAILABLE"

    #: A constant which can be used with the lifecycle_state property of a ReverseConnectionNatIp.
    #: This constant has a value of "TERMINATING"
    LIFECYCLE_STATE_TERMINATING = "TERMINATING"

    #: A constant which can be used with the lifecycle_state property of a ReverseConnectionNatIp.
    #: This constant has a value of "TERMINATED"
    LIFECYCLE_STATE_TERMINATED = "TERMINATED"

    def __init__(self, **kwargs):
        """
        Initializes a new ReverseConnectionNatIp object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this ReverseConnectionNatIp.
            Allowed values for this property are: "PROVISIONING", "AVAILABLE", "TERMINATING", "TERMINATED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param time_created:
            The value to assign to the time_created property of this ReverseConnectionNatIp.
        :type time_created: datetime

        :param reverse_connection_customer_ip:
            The value to assign to the reverse_connection_customer_ip property of this ReverseConnectionNatIp.
        :type reverse_connection_customer_ip: str

        :param reverse_connection_nat_ip:
            The value to assign to the reverse_connection_nat_ip property of this ReverseConnectionNatIp.
        :type reverse_connection_nat_ip: str

        :param private_endpoint_id:
            The value to assign to the private_endpoint_id property of this ReverseConnectionNatIp.
        :type private_endpoint_id: str

        """
        self.swagger_types = {
            'lifecycle_state': 'str',
            'time_created': 'datetime',
            'reverse_connection_customer_ip': 'str',
            'reverse_connection_nat_ip': 'str',
            'private_endpoint_id': 'str'
        }

        self.attribute_map = {
            'lifecycle_state': 'lifecycleState',
            'time_created': 'timeCreated',
            'reverse_connection_customer_ip': 'reverseConnectionCustomerIp',
            'reverse_connection_nat_ip': 'reverseConnectionNatIp',
            'private_endpoint_id': 'privateEndpointId'
        }

        self._lifecycle_state = None
        self._time_created = None
        self._reverse_connection_customer_ip = None
        self._reverse_connection_nat_ip = None
        self._private_endpoint_id = None

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this ReverseConnectionNatIp.
        The Reverse Connection NAT IP's current state.

        Allowed values for this property are: "PROVISIONING", "AVAILABLE", "TERMINATING", "TERMINATED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this ReverseConnectionNatIp.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this ReverseConnectionNatIp.
        The Reverse Connection NAT IP's current state.


        :param lifecycle_state: The lifecycle_state of this ReverseConnectionNatIp.
        :type: str
        """
        allowed_values = ["PROVISIONING", "AVAILABLE", "TERMINATING", "TERMINATED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this ReverseConnectionNatIp.
        The date and time the Reverse Connection NAT IP was created, in the format defined by RFC3339.

        Example: '2016-08-25T21:10:29.600Z'


        :return: The time_created of this ReverseConnectionNatIp.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this ReverseConnectionNatIp.
        The date and time the Reverse Connection NAT IP was created, in the format defined by RFC3339.

        Example: '2016-08-25T21:10:29.600Z'


        :param time_created: The time_created of this ReverseConnectionNatIp.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def reverse_connection_customer_ip(self):
        """
        **[Required]** Gets the reverse_connection_customer_ip of this ReverseConnectionNatIp.
        Customer's IP address to which the reverse connection is going to be established.


        :return: The reverse_connection_customer_ip of this ReverseConnectionNatIp.
        :rtype: str
        """
        return self._reverse_connection_customer_ip

    @reverse_connection_customer_ip.setter
    def reverse_connection_customer_ip(self, reverse_connection_customer_ip):
        """
        Sets the reverse_connection_customer_ip of this ReverseConnectionNatIp.
        Customer's IP address to which the reverse connection is going to be established.


        :param reverse_connection_customer_ip: The reverse_connection_customer_ip of this ReverseConnectionNatIp.
        :type: str
        """
        self._reverse_connection_customer_ip = reverse_connection_customer_ip

    @property
    def reverse_connection_nat_ip(self):
        """
        **[Required]** Gets the reverse_connection_nat_ip of this ReverseConnectionNatIp.
        The Reverse Connection NAT IP address associated with the customer IP and peId.


        :return: The reverse_connection_nat_ip of this ReverseConnectionNatIp.
        :rtype: str
        """
        return self._reverse_connection_nat_ip

    @reverse_connection_nat_ip.setter
    def reverse_connection_nat_ip(self, reverse_connection_nat_ip):
        """
        Sets the reverse_connection_nat_ip of this ReverseConnectionNatIp.
        The Reverse Connection NAT IP address associated with the customer IP and peId.


        :param reverse_connection_nat_ip: The reverse_connection_nat_ip of this ReverseConnectionNatIp.
        :type: str
        """
        self._reverse_connection_nat_ip = reverse_connection_nat_ip

    @property
    def private_endpoint_id(self):
        """
        **[Required]** Gets the private_endpoint_id of this ReverseConnectionNatIp.
        The OCID of the customer's Private Endpoint associated with the Reverse Connection.


        :return: The private_endpoint_id of this ReverseConnectionNatIp.
        :rtype: str
        """
        return self._private_endpoint_id

    @private_endpoint_id.setter
    def private_endpoint_id(self, private_endpoint_id):
        """
        Sets the private_endpoint_id of this ReverseConnectionNatIp.
        The OCID of the customer's Private Endpoint associated with the Reverse Connection.


        :param private_endpoint_id: The private_endpoint_id of this ReverseConnectionNatIp.
        :type: str
        """
        self._private_endpoint_id = private_endpoint_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
