# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ReverseConnectionsSourceIpDetails(object):
    """
    IP information for Reverse Connections Configuration, this will be a part of Private Endpoint object that is returned.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ReverseConnectionsSourceIpDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param source_ip:
            The value to assign to the source_ip property of this ReverseConnectionsSourceIpDetails.
        :type source_ip: str

        """
        self.swagger_types = {
            'source_ip': 'str'
        }

        self.attribute_map = {
            'source_ip': 'sourceIp'
        }

        self._source_ip = None

    @property
    def source_ip(self):
        """
        Gets the source_ip of this ReverseConnectionsSourceIpDetails.
        The IP that will be used as source for reverse connections.


        :return: The source_ip of this ReverseConnectionsSourceIpDetails.
        :rtype: str
        """
        return self._source_ip

    @source_ip.setter
    def source_ip(self, source_ip):
        """
        Sets the source_ip of this ReverseConnectionsSourceIpDetails.
        The IP that will be used as source for reverse connections.


        :param source_ip: The source_ip of this ReverseConnectionsSourceIpDetails.
        :type: str
        """
        self._source_ip = source_ip

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
