# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateEndpointServiceDetails(object):
    """
    Information that can be updated for an endpoint service.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateEndpointServiceDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param description:
            The value to assign to the description property of this UpdateEndpointServiceDetails.
        :type description: str

        :param display_name:
            The value to assign to the display_name property of this UpdateEndpointServiceDetails.
        :type display_name: str

        :param are_multiple_private_endpoints_per_vcn_allowed:
            The value to assign to the are_multiple_private_endpoints_per_vcn_allowed property of this UpdateEndpointServiceDetails.
        :type are_multiple_private_endpoints_per_vcn_allowed: bool

        :param is_vcn_metadata_enabled:
            The value to assign to the is_vcn_metadata_enabled property of this UpdateEndpointServiceDetails.
        :type is_vcn_metadata_enabled: bool

        :param service_ips:
            The value to assign to the service_ips property of this UpdateEndpointServiceDetails.
        :type service_ips: list[EndpointServiceIpDetails]

        :param ports:
            The value to assign to the ports property of this UpdateEndpointServiceDetails.
        :type ports: list[int]

        :param defined_tags:
            The value to assign to the defined_tags property of this UpdateEndpointServiceDetails.
        :type defined_tags: dict(str, dict(str, object))

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UpdateEndpointServiceDetails.
        :type freeform_tags: dict(str, str)

        """
        self.swagger_types = {
            'description': 'str',
            'display_name': 'str',
            'are_multiple_private_endpoints_per_vcn_allowed': 'bool',
            'is_vcn_metadata_enabled': 'bool',
            'service_ips': 'list[EndpointServiceIpDetails]',
            'ports': 'list[int]',
            'defined_tags': 'dict(str, dict(str, object))',
            'freeform_tags': 'dict(str, str)'
        }

        self.attribute_map = {
            'description': 'description',
            'display_name': 'displayName',
            'are_multiple_private_endpoints_per_vcn_allowed': 'areMultiplePrivateEndpointsPerVcnAllowed',
            'is_vcn_metadata_enabled': 'isVcnMetadataEnabled',
            'service_ips': 'serviceIps',
            'ports': 'ports',
            'defined_tags': 'definedTags',
            'freeform_tags': 'freeformTags'
        }

        self._description = None
        self._display_name = None
        self._are_multiple_private_endpoints_per_vcn_allowed = None
        self._is_vcn_metadata_enabled = None
        self._service_ips = None
        self._ports = None
        self._defined_tags = None
        self._freeform_tags = None

    @property
    def description(self):
        """
        Gets the description of this UpdateEndpointServiceDetails.
        A description of the endpoint service. For Oracle services that use the \"trusted\" mode of the
        private endpoint service, customers never see this description. Avoid entering confidential
        information.


        :return: The description of this UpdateEndpointServiceDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this UpdateEndpointServiceDetails.
        A description of the endpoint service. For Oracle services that use the \"trusted\" mode of the
        private endpoint service, customers never see this description. Avoid entering confidential
        information.


        :param description: The description of this UpdateEndpointServiceDetails.
        :type: str
        """
        self._description = description

    @property
    def display_name(self):
        """
        Gets the display_name of this UpdateEndpointServiceDetails.
        A friendly name for the endpoint service. Must be unique within the VCN. Avoid entering
        confidential information.


        :return: The display_name of this UpdateEndpointServiceDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this UpdateEndpointServiceDetails.
        A friendly name for the endpoint service. Must be unique within the VCN. Avoid entering
        confidential information.


        :param display_name: The display_name of this UpdateEndpointServiceDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def are_multiple_private_endpoints_per_vcn_allowed(self):
        """
        Gets the are_multiple_private_endpoints_per_vcn_allowed of this UpdateEndpointServiceDetails.
        Some services want to restrict access to the resources represented by an endpoint service so
        that only a single private endpoint in the customer VCN has access.

        For example, the endpoint service might represent a particular service resource (such as a
        particular database). The service might want to allow access to that particular resource
        from only a single private endpoint.

        Defaults to `false`.

        Example: `true`


        :return: The are_multiple_private_endpoints_per_vcn_allowed of this UpdateEndpointServiceDetails.
        :rtype: bool
        """
        return self._are_multiple_private_endpoints_per_vcn_allowed

    @are_multiple_private_endpoints_per_vcn_allowed.setter
    def are_multiple_private_endpoints_per_vcn_allowed(self, are_multiple_private_endpoints_per_vcn_allowed):
        """
        Sets the are_multiple_private_endpoints_per_vcn_allowed of this UpdateEndpointServiceDetails.
        Some services want to restrict access to the resources represented by an endpoint service so
        that only a single private endpoint in the customer VCN has access.

        For example, the endpoint service might represent a particular service resource (such as a
        particular database). The service might want to allow access to that particular resource
        from only a single private endpoint.

        Defaults to `false`.

        Example: `true`


        :param are_multiple_private_endpoints_per_vcn_allowed: The are_multiple_private_endpoints_per_vcn_allowed of this UpdateEndpointServiceDetails.
        :type: bool
        """
        self._are_multiple_private_endpoints_per_vcn_allowed = are_multiple_private_endpoints_per_vcn_allowed

    @property
    def is_vcn_metadata_enabled(self):
        """
        Gets the is_vcn_metadata_enabled of this UpdateEndpointServiceDetails.
        Reserved for future use.


        :return: The is_vcn_metadata_enabled of this UpdateEndpointServiceDetails.
        :rtype: bool
        """
        return self._is_vcn_metadata_enabled

    @is_vcn_metadata_enabled.setter
    def is_vcn_metadata_enabled(self, is_vcn_metadata_enabled):
        """
        Sets the is_vcn_metadata_enabled of this UpdateEndpointServiceDetails.
        Reserved for future use.


        :param is_vcn_metadata_enabled: The is_vcn_metadata_enabled of this UpdateEndpointServiceDetails.
        :type: bool
        """
        self._is_vcn_metadata_enabled = is_vcn_metadata_enabled

    @property
    def service_ips(self):
        """
        Gets the service_ips of this UpdateEndpointServiceDetails.
        List of service IP addresses (in the service VCN) that handle requests to the endpoint service.


        :return: The service_ips of this UpdateEndpointServiceDetails.
        :rtype: list[EndpointServiceIpDetails]
        """
        return self._service_ips

    @service_ips.setter
    def service_ips(self, service_ips):
        """
        Sets the service_ips of this UpdateEndpointServiceDetails.
        List of service IP addresses (in the service VCN) that handle requests to the endpoint service.


        :param service_ips: The service_ips of this UpdateEndpointServiceDetails.
        :type: list[EndpointServiceIpDetails]
        """
        self._service_ips = service_ips

    @property
    def ports(self):
        """
        Gets the ports of this UpdateEndpointServiceDetails.
        The ports on the endpoint service IPs that are open for private endpoint traffic for this
        endpoint service. If you provide no ports, all open ports on the service IPs are accessible.


        :return: The ports of this UpdateEndpointServiceDetails.
        :rtype: list[int]
        """
        return self._ports

    @ports.setter
    def ports(self, ports):
        """
        Sets the ports of this UpdateEndpointServiceDetails.
        The ports on the endpoint service IPs that are open for private endpoint traffic for this
        endpoint service. If you provide no ports, all open ports on the service IPs are accessible.


        :param ports: The ports of this UpdateEndpointServiceDetails.
        :type: list[int]
        """
        self._ports = ports

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this UpdateEndpointServiceDetails.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this UpdateEndpointServiceDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this UpdateEndpointServiceDetails.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this UpdateEndpointServiceDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this UpdateEndpointServiceDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this UpdateEndpointServiceDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this UpdateEndpointServiceDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this UpdateEndpointServiceDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
