# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Glossary(object):
    """
    Full Glossary details. A glossary of business terms, such as 'Customer', 'Account', 'Contact' , 'Address',
    'Product' etc. with definitions, used to provide common meaning across disparate Data Assets. Business Glossaries
    may be hierarchical where some terms may contain child terms to allow them to be used as 'taxonomies'.
    By linking Data Assets, data entities and attributes to glossaries and glossary terms, the glossary can act as a
    way of organizing Catalog objects in a hierarchy to make a large number of objects more navigable and easier to
    consume. Objects in the Data Catalog, such as Data Assets or Data Entities, may be linked to any level in the
    Glossary, so that the Glossary can be used to browse the available data according to the business model of the
    organization.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new Glossary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param key:
            The value to assign to the key property of this Glossary.
        :type key: str

        :param display_name:
            The value to assign to the display_name property of this Glossary.
        :type display_name: str

        :param description:
            The value to assign to the description property of this Glossary.
        :type description: str

        :param catalog_id:
            The value to assign to the catalog_id property of this Glossary.
        :type catalog_id: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this Glossary.
        :type lifecycle_state: str

        :param time_created:
            The value to assign to the time_created property of this Glossary.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this Glossary.
        :type time_updated: datetime

        :param created_by_id:
            The value to assign to the created_by_id property of this Glossary.
        :type created_by_id: str

        :param updated_by_id:
            The value to assign to the updated_by_id property of this Glossary.
        :type updated_by_id: str

        :param owner:
            The value to assign to the owner property of this Glossary.
        :type owner: str

        :param uri:
            The value to assign to the uri property of this Glossary.
        :type uri: str

        """
        self.swagger_types = {
            'key': 'str',
            'display_name': 'str',
            'description': 'str',
            'catalog_id': 'str',
            'lifecycle_state': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'created_by_id': 'str',
            'updated_by_id': 'str',
            'owner': 'str',
            'uri': 'str'
        }

        self.attribute_map = {
            'key': 'key',
            'display_name': 'displayName',
            'description': 'description',
            'catalog_id': 'catalogId',
            'lifecycle_state': 'lifecycleState',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'created_by_id': 'createdById',
            'updated_by_id': 'updatedById',
            'owner': 'owner',
            'uri': 'uri'
        }

        self._key = None
        self._display_name = None
        self._description = None
        self._catalog_id = None
        self._lifecycle_state = None
        self._time_created = None
        self._time_updated = None
        self._created_by_id = None
        self._updated_by_id = None
        self._owner = None
        self._uri = None

    @property
    def key(self):
        """
        **[Required]** Gets the key of this Glossary.
        Unique glossary key that is immutable.


        :return: The key of this Glossary.
        :rtype: str
        """
        return self._key

    @key.setter
    def key(self, key):
        """
        Sets the key of this Glossary.
        Unique glossary key that is immutable.


        :param key: The key of this Glossary.
        :type: str
        """
        self._key = key

    @property
    def display_name(self):
        """
        Gets the display_name of this Glossary.
        The display name of a user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :return: The display_name of this Glossary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this Glossary.
        The display name of a user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :param display_name: The display_name of this Glossary.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this Glossary.
        Detailed description of the Glossary.


        :return: The description of this Glossary.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this Glossary.
        Detailed description of the Glossary.


        :param description: The description of this Glossary.
        :type: str
        """
        self._description = description

    @property
    def catalog_id(self):
        """
        Gets the catalog_id of this Glossary.
        The Catalog's Oracle ID (OCID).


        :return: The catalog_id of this Glossary.
        :rtype: str
        """
        return self._catalog_id

    @catalog_id.setter
    def catalog_id(self, catalog_id):
        """
        Sets the catalog_id of this Glossary.
        The Catalog's Oracle ID (OCID).


        :param catalog_id: The catalog_id of this Glossary.
        :type: str
        """
        self._catalog_id = catalog_id

    @property
    def lifecycle_state(self):
        """
        Gets the lifecycle_state of this Glossary.
        The current state of the Glossary.


        :return: The lifecycle_state of this Glossary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this Glossary.
        The current state of the Glossary.


        :param lifecycle_state: The lifecycle_state of this Glossary.
        :type: str
        """
        self._lifecycle_state = lifecycle_state

    @property
    def time_created(self):
        """
        Gets the time_created of this Glossary.
        The date and time the Glossary was created, in the format defined by RFC3339.
        Example: `2019-03-25T21:10:29.600Z`


        :return: The time_created of this Glossary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this Glossary.
        The date and time the Glossary was created, in the format defined by RFC3339.
        Example: `2019-03-25T21:10:29.600Z`


        :param time_created: The time_created of this Glossary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this Glossary.
        The last time that any change was made to the Glossary. An RFC3339 formatted datetime string.


        :return: The time_updated of this Glossary.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this Glossary.
        The last time that any change was made to the Glossary. An RFC3339 formatted datetime string.


        :param time_updated: The time_updated of this Glossary.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def created_by_id(self):
        """
        Gets the created_by_id of this Glossary.
        Id (OCID) of the user who created this metadata element.


        :return: The created_by_id of this Glossary.
        :rtype: str
        """
        return self._created_by_id

    @created_by_id.setter
    def created_by_id(self, created_by_id):
        """
        Sets the created_by_id of this Glossary.
        Id (OCID) of the user who created this metadata element.


        :param created_by_id: The created_by_id of this Glossary.
        :type: str
        """
        self._created_by_id = created_by_id

    @property
    def updated_by_id(self):
        """
        Gets the updated_by_id of this Glossary.
        Id (OCID) of the user who updated this metadata element.


        :return: The updated_by_id of this Glossary.
        :rtype: str
        """
        return self._updated_by_id

    @updated_by_id.setter
    def updated_by_id(self, updated_by_id):
        """
        Sets the updated_by_id of this Glossary.
        Id (OCID) of the user who updated this metadata element.


        :param updated_by_id: The updated_by_id of this Glossary.
        :type: str
        """
        self._updated_by_id = updated_by_id

    @property
    def owner(self):
        """
        Gets the owner of this Glossary.
        Id (OCID) of the user who is the owner of the glossary.


        :return: The owner of this Glossary.
        :rtype: str
        """
        return self._owner

    @owner.setter
    def owner(self, owner):
        """
        Sets the owner of this Glossary.
        Id (OCID) of the user who is the owner of the glossary.


        :param owner: The owner of this Glossary.
        :type: str
        """
        self._owner = owner

    @property
    def uri(self):
        """
        Gets the uri of this Glossary.
        URI to the Tag instance in the API.


        :return: The uri of this Glossary.
        :rtype: str
        """
        return self._uri

    @uri.setter
    def uri(self, uri):
        """
        Sets the uri of this Glossary.
        URI to the Tag instance in the API.


        :param uri: The uri of this Glossary.
        :type: str
        """
        self._uri = uri

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
