# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class JobExecutionSummary(object):
    """
    A list of Job Executions. A Job Execution is a unit of work being executed on behalf of a Job.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new JobExecutionSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param key:
            The value to assign to the key property of this JobExecutionSummary.
        :type key: str

        :param job_key:
            The value to assign to the job_key property of this JobExecutionSummary.
        :type job_key: str

        :param job_type:
            The value to assign to the job_type property of this JobExecutionSummary.
        :type job_type: str

        :param parent_key:
            The value to assign to the parent_key property of this JobExecutionSummary.
        :type parent_key: str

        :param schedule_instance_key:
            The value to assign to the schedule_instance_key property of this JobExecutionSummary.
        :type schedule_instance_key: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this JobExecutionSummary.
        :type lifecycle_state: str

        :param time_created:
            The value to assign to the time_created property of this JobExecutionSummary.
        :type time_created: datetime

        :param time_started:
            The value to assign to the time_started property of this JobExecutionSummary.
        :type time_started: datetime

        :param time_ended:
            The value to assign to the time_ended property of this JobExecutionSummary.
        :type time_ended: datetime

        :param uri:
            The value to assign to the uri property of this JobExecutionSummary.
        :type uri: str

        """
        self.swagger_types = {
            'key': 'str',
            'job_key': 'str',
            'job_type': 'str',
            'parent_key': 'str',
            'schedule_instance_key': 'str',
            'lifecycle_state': 'str',
            'time_created': 'datetime',
            'time_started': 'datetime',
            'time_ended': 'datetime',
            'uri': 'str'
        }

        self.attribute_map = {
            'key': 'key',
            'job_key': 'jobKey',
            'job_type': 'jobType',
            'parent_key': 'parentKey',
            'schedule_instance_key': 'scheduleInstanceKey',
            'lifecycle_state': 'lifecycleState',
            'time_created': 'timeCreated',
            'time_started': 'timeStarted',
            'time_ended': 'timeEnded',
            'uri': 'uri'
        }

        self._key = None
        self._job_key = None
        self._job_type = None
        self._parent_key = None
        self._schedule_instance_key = None
        self._lifecycle_state = None
        self._time_created = None
        self._time_started = None
        self._time_ended = None
        self._uri = None

    @property
    def key(self):
        """
        **[Required]** Gets the key of this JobExecutionSummary.
        Unique key of the Job Execution resource.


        :return: The key of this JobExecutionSummary.
        :rtype: str
        """
        return self._key

    @key.setter
    def key(self, key):
        """
        Sets the key of this JobExecutionSummary.
        Unique key of the Job Execution resource.


        :param key: The key of this JobExecutionSummary.
        :type: str
        """
        self._key = key

    @property
    def job_key(self):
        """
        Gets the job_key of this JobExecutionSummary.
        The unique key of the parent Job.


        :return: The job_key of this JobExecutionSummary.
        :rtype: str
        """
        return self._job_key

    @job_key.setter
    def job_key(self, job_key):
        """
        Sets the job_key of this JobExecutionSummary.
        The unique key of the parent Job.


        :param job_key: The job_key of this JobExecutionSummary.
        :type: str
        """
        self._job_key = job_key

    @property
    def job_type(self):
        """
        Gets the job_type of this JobExecutionSummary.
        Type of the Job Execution.


        :return: The job_type of this JobExecutionSummary.
        :rtype: str
        """
        return self._job_type

    @job_type.setter
    def job_type(self, job_type):
        """
        Sets the job_type of this JobExecutionSummary.
        Type of the Job Execution.


        :param job_type: The job_type of this JobExecutionSummary.
        :type: str
        """
        self._job_type = job_type

    @property
    def parent_key(self):
        """
        Gets the parent_key of this JobExecutionSummary.
        The unique key of the parent execution or null if this Job Execution has no parent.


        :return: The parent_key of this JobExecutionSummary.
        :rtype: str
        """
        return self._parent_key

    @parent_key.setter
    def parent_key(self, parent_key):
        """
        Sets the parent_key of this JobExecutionSummary.
        The unique key of the parent execution or null if this Job Execution has no parent.


        :param parent_key: The parent_key of this JobExecutionSummary.
        :type: str
        """
        self._parent_key = parent_key

    @property
    def schedule_instance_key(self):
        """
        Gets the schedule_instance_key of this JobExecutionSummary.
        The unique key of the triggering external scheduler resource or null if this Job Execution is not externally triggered.


        :return: The schedule_instance_key of this JobExecutionSummary.
        :rtype: str
        """
        return self._schedule_instance_key

    @schedule_instance_key.setter
    def schedule_instance_key(self, schedule_instance_key):
        """
        Sets the schedule_instance_key of this JobExecutionSummary.
        The unique key of the triggering external scheduler resource or null if this Job Execution is not externally triggered.


        :param schedule_instance_key: The schedule_instance_key of this JobExecutionSummary.
        :type: str
        """
        self._schedule_instance_key = schedule_instance_key

    @property
    def lifecycle_state(self):
        """
        Gets the lifecycle_state of this JobExecutionSummary.
        Status of the Job Execution. For eg: Running, Paused, Completed etc


        :return: The lifecycle_state of this JobExecutionSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this JobExecutionSummary.
        Status of the Job Execution. For eg: Running, Paused, Completed etc


        :param lifecycle_state: The lifecycle_state of this JobExecutionSummary.
        :type: str
        """
        self._lifecycle_state = lifecycle_state

    @property
    def time_created(self):
        """
        Gets the time_created of this JobExecutionSummary.
        The date and time the JobExecution was created, in the format defined by RFC3339.
        Example: `2019-03-25T21:10:29.600Z`


        :return: The time_created of this JobExecutionSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this JobExecutionSummary.
        The date and time the JobExecution was created, in the format defined by RFC3339.
        Example: `2019-03-25T21:10:29.600Z`


        :param time_created: The time_created of this JobExecutionSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_started(self):
        """
        Gets the time_started of this JobExecutionSummary.
        Time that Job Execution started. An RFC3339 formatted datetime string.


        :return: The time_started of this JobExecutionSummary.
        :rtype: datetime
        """
        return self._time_started

    @time_started.setter
    def time_started(self, time_started):
        """
        Sets the time_started of this JobExecutionSummary.
        Time that Job Execution started. An RFC3339 formatted datetime string.


        :param time_started: The time_started of this JobExecutionSummary.
        :type: datetime
        """
        self._time_started = time_started

    @property
    def time_ended(self):
        """
        Gets the time_ended of this JobExecutionSummary.
        Time that the Job Execution ended or null if it hasn't yet completed.
        An RFC3339 formatted datetime string.


        :return: The time_ended of this JobExecutionSummary.
        :rtype: datetime
        """
        return self._time_ended

    @time_ended.setter
    def time_ended(self, time_ended):
        """
        Sets the time_ended of this JobExecutionSummary.
        Time that the Job Execution ended or null if it hasn't yet completed.
        An RFC3339 formatted datetime string.


        :param time_ended: The time_ended of this JobExecutionSummary.
        :type: datetime
        """
        self._time_ended = time_ended

    @property
    def uri(self):
        """
        Gets the uri of this JobExecutionSummary.
        URI to the Job Execution instance in the API.


        :return: The uri of this JobExecutionSummary.
        :rtype: str
        """
        return self._uri

    @uri.setter
    def uri(self, uri):
        """
        Sets the uri of this JobExecutionSummary.
        URI to the Job Execution instance in the API.


        :param uri: The uri of this JobExecutionSummary.
        :type: str
        """
        self._uri = uri

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
