# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SearchCriteria(object):
    """
    Search Query object that allows complex search predicates that cannot be expressed through simple query params.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new SearchCriteria object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param fields:
            The value to assign to the fields property of this SearchCriteria.
        :type fields: list[str]

        :param query:
            The value to assign to the query property of this SearchCriteria.
        :type query: str

        """
        self.swagger_types = {
            'fields': 'list[str]',
            'query': 'str'
        }

        self.attribute_map = {
            'fields': 'fields',
            'query': 'query'
        }

        self._fields = None
        self._query = None

    @property
    def fields(self):
        """
        Gets the fields of this SearchCriteria.
        The set of attributes that is part of the search query criteria. Used along with Search Criteria query parameter.


        :return: The fields of this SearchCriteria.
        :rtype: list[str]
        """
        return self._fields

    @fields.setter
    def fields(self, fields):
        """
        Sets the fields of this SearchCriteria.
        The set of attributes that is part of the search query criteria. Used along with Search Criteria query parameter.


        :param fields: The fields of this SearchCriteria.
        :type: list[str]
        """
        self._fields = fields

    @property
    def query(self):
        """
        Gets the query of this SearchCriteria.
        Search query dsl that defines the query components including fields and predicates.


        :return: The query of this SearchCriteria.
        :rtype: str
        """
        return self._query

    @query.setter
    def query(self, query):
        """
        Sets the query of this SearchCriteria.
        Search query dsl that defines the query components including fields and predicates.


        :param query: The query of this SearchCriteria.
        :type: str
        """
        self._query = query

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
