# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SearchQuery(object):
    """
    Search Query object that allows complex search predicates that cannot be expressed through simple query params.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new SearchQuery object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param fields:
            The value to assign to the fields property of this SearchQuery.
        :type fields: list[str]

        :param predicate:
            The value to assign to the predicate property of this SearchQuery.
        :type predicate: str

        """
        self.swagger_types = {
            'fields': 'list[str]',
            'predicate': 'str'
        }

        self.attribute_map = {
            'fields': 'fields',
            'predicate': 'predicate'
        }

        self._fields = None
        self._predicate = None

    @property
    def fields(self):
        """
        Gets the fields of this SearchQuery.
        The set of attributes that is part of the search query criteria


        :return: The fields of this SearchQuery.
        :rtype: list[str]
        """
        return self._fields

    @fields.setter
    def fields(self, fields):
        """
        Sets the fields of this SearchQuery.
        The set of attributes that is part of the search query criteria


        :param fields: The fields of this SearchQuery.
        :type: list[str]
        """
        self._fields = fields

    @property
    def predicate(self):
        """
        Gets the predicate of this SearchQuery.
        Qualifier query predicate expression. For example, this AND that OR thus


        :return: The predicate of this SearchQuery.
        :rtype: str
        """
        return self._predicate

    @predicate.setter
    def predicate(self, predicate):
        """
        Sets the predicate of this SearchQuery.
        Qualifier query predicate expression. For example, this AND that OR thus


        :param predicate: The predicate of this SearchQuery.
        :type: str
        """
        self._predicate = predicate

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
