# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ValidateConnectionsDetails(object):
    """
    Validate Connections from the connection metadata or oracle wallet file
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ValidateConnectionsDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param connections_detail_array:
            The value to assign to the connections_detail_array property of this ValidateConnectionsDetails.
        :type connections_detail_array: list[CreateConnectionDetails]

        :param connections_payload:
            The value to assign to the connections_payload property of this ValidateConnectionsDetails.
        :type connections_payload: str

        """
        self.swagger_types = {
            'connections_detail_array': 'list[CreateConnectionDetails]',
            'connections_payload': 'str'
        }

        self.attribute_map = {
            'connections_detail_array': 'connectionsDetailArray',
            'connections_payload': 'connectionsPayload'
        }

        self._connections_detail_array = None
        self._connections_payload = None

    @property
    def connections_detail_array(self):
        """
        Gets the connections_detail_array of this ValidateConnectionsDetails.
        The connection details array that will be used to validate the connections.


        :return: The connections_detail_array of this ValidateConnectionsDetails.
        :rtype: list[CreateConnectionDetails]
        """
        return self._connections_detail_array

    @connections_detail_array.setter
    def connections_detail_array(self, connections_detail_array):
        """
        Sets the connections_detail_array of this ValidateConnectionsDetails.
        The connection details array that will be used to validate the connections.


        :param connections_detail_array: The connections_detail_array of this ValidateConnectionsDetails.
        :type: list[CreateConnectionDetails]
        """
        self._connections_detail_array = connections_detail_array

    @property
    def connections_payload(self):
        """
        Gets the connections_payload of this ValidateConnectionsDetails.
        The information used to validate the connections


        :return: The connections_payload of this ValidateConnectionsDetails.
        :rtype: str
        """
        return self._connections_payload

    @connections_payload.setter
    def connections_payload(self, connections_payload):
        """
        Sets the connections_payload of this ValidateConnectionsDetails.
        The information used to validate the connections


        :param connections_payload: The connections_payload of this ValidateConnectionsDetails.
        :type: str
        """
        self._connections_payload = connections_payload

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
