# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.

from .create_db_home_base import CreateDbHomeBase
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateDbHomeWithVmClusterIdFromDatabaseDetails(CreateDbHomeBase):
    """
    Note that a valid `vmClusterId` value must be supplied for the `CreateDbHomeWithVmClusterIdFromDatabase` API operation to successfully complete.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateDbHomeWithVmClusterIdFromDatabaseDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.database.models.CreateDbHomeWithVmClusterIdFromDatabaseDetails.source` attribute
        of this class is ``VM_CLUSTER_DATABASE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this CreateDbHomeWithVmClusterIdFromDatabaseDetails.
        :type display_name: str

        :param kms_key_id:
            The value to assign to the kms_key_id property of this CreateDbHomeWithVmClusterIdFromDatabaseDetails.
        :type kms_key_id: str

        :param kms_key_version_id:
            The value to assign to the kms_key_version_id property of this CreateDbHomeWithVmClusterIdFromDatabaseDetails.
        :type kms_key_version_id: str

        :param source:
            The value to assign to the source property of this CreateDbHomeWithVmClusterIdFromDatabaseDetails.
            Allowed values for this property are: "NONE", "DB_BACKUP", "DATABASE", "VM_CLUSTER_NEW", "VM_CLUSTER_DATABASE"
        :type source: str

        :param vm_cluster_id:
            The value to assign to the vm_cluster_id property of this CreateDbHomeWithVmClusterIdFromDatabaseDetails.
        :type vm_cluster_id: str

        :param database:
            The value to assign to the database property of this CreateDbHomeWithVmClusterIdFromDatabaseDetails.
        :type database: CreateDatabaseFromAnotherDatabaseDetails

        """
        self.swagger_types = {
            'display_name': 'str',
            'kms_key_id': 'str',
            'kms_key_version_id': 'str',
            'source': 'str',
            'vm_cluster_id': 'str',
            'database': 'CreateDatabaseFromAnotherDatabaseDetails'
        }

        self.attribute_map = {
            'display_name': 'displayName',
            'kms_key_id': 'kmsKeyId',
            'kms_key_version_id': 'kmsKeyVersionId',
            'source': 'source',
            'vm_cluster_id': 'vmClusterId',
            'database': 'database'
        }

        self._display_name = None
        self._kms_key_id = None
        self._kms_key_version_id = None
        self._source = None
        self._vm_cluster_id = None
        self._database = None
        self._source = 'VM_CLUSTER_DATABASE'

    @property
    def vm_cluster_id(self):
        """
        **[Required]** Gets the vm_cluster_id of this CreateDbHomeWithVmClusterIdFromDatabaseDetails.
        The `OCID`__ of the VM cluster.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The vm_cluster_id of this CreateDbHomeWithVmClusterIdFromDatabaseDetails.
        :rtype: str
        """
        return self._vm_cluster_id

    @vm_cluster_id.setter
    def vm_cluster_id(self, vm_cluster_id):
        """
        Sets the vm_cluster_id of this CreateDbHomeWithVmClusterIdFromDatabaseDetails.
        The `OCID`__ of the VM cluster.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param vm_cluster_id: The vm_cluster_id of this CreateDbHomeWithVmClusterIdFromDatabaseDetails.
        :type: str
        """
        self._vm_cluster_id = vm_cluster_id

    @property
    def database(self):
        """
        **[Required]** Gets the database of this CreateDbHomeWithVmClusterIdFromDatabaseDetails.

        :return: The database of this CreateDbHomeWithVmClusterIdFromDatabaseDetails.
        :rtype: CreateDatabaseFromAnotherDatabaseDetails
        """
        return self._database

    @database.setter
    def database(self, database):
        """
        Sets the database of this CreateDbHomeWithVmClusterIdFromDatabaseDetails.

        :param database: The database of this CreateDbHomeWithVmClusterIdFromDatabaseDetails.
        :type: CreateDatabaseFromAnotherDatabaseDetails
        """
        self._database = database

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
