# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MoveDatabaseDetails(object):
    """
    Move Database Details
    """

    def __init__(self, **kwargs):
        """
        Initializes a new MoveDatabaseDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param target_db_home_id:
            The value to assign to the target_db_home_id property of this MoveDatabaseDetails.
        :type target_db_home_id: str

        """
        self.swagger_types = {
            'target_db_home_id': 'str'
        }

        self.attribute_map = {
            'target_db_home_id': 'targetDbHomeId'
        }

        self._target_db_home_id = None

    @property
    def target_db_home_id(self):
        """
        **[Required]** Gets the target_db_home_id of this MoveDatabaseDetails.
        The `OCID`__ of the destination DB Home to move the database.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The target_db_home_id of this MoveDatabaseDetails.
        :rtype: str
        """
        return self._target_db_home_id

    @target_db_home_id.setter
    def target_db_home_id(self, target_db_home_id):
        """
        Sets the target_db_home_id of this MoveDatabaseDetails.
        The `OCID`__ of the destination DB Home to move the database.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param target_db_home_id: The target_db_home_id of this MoveDatabaseDetails.
        :type: str
        """
        self._target_db_home_id = target_db_home_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
