# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.

from .action_details import ActionDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateObjectStorageServiceActionDetails(ActionDetails):
    """
    Create an action that delivers to an Oracle Object Storage bucket.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateObjectStorageServiceActionDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.events.models.CreateObjectStorageServiceActionDetails.action_type` attribute
        of this class is ``OBJECTSTORAGE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param action_type:
            The value to assign to the action_type property of this CreateObjectStorageServiceActionDetails.
            Allowed values for this property are: "ONS", "OSS", "FAAS", "OBJECTSTORAGE"
        :type action_type: str

        :param is_enabled:
            The value to assign to the is_enabled property of this CreateObjectStorageServiceActionDetails.
        :type is_enabled: bool

        :param description:
            The value to assign to the description property of this CreateObjectStorageServiceActionDetails.
        :type description: str

        :param namespace_name:
            The value to assign to the namespace_name property of this CreateObjectStorageServiceActionDetails.
        :type namespace_name: str

        :param bucket_name:
            The value to assign to the bucket_name property of this CreateObjectStorageServiceActionDetails.
        :type bucket_name: str

        """
        self.swagger_types = {
            'action_type': 'str',
            'is_enabled': 'bool',
            'description': 'str',
            'namespace_name': 'str',
            'bucket_name': 'str'
        }

        self.attribute_map = {
            'action_type': 'actionType',
            'is_enabled': 'isEnabled',
            'description': 'description',
            'namespace_name': 'namespaceName',
            'bucket_name': 'bucketName'
        }

        self._action_type = None
        self._is_enabled = None
        self._description = None
        self._namespace_name = None
        self._bucket_name = None
        self._action_type = 'OBJECTSTORAGE'

    @property
    def namespace_name(self):
        """
        **[Required]** Gets the namespace_name of this CreateObjectStorageServiceActionDetails.
        The Object Storage namespace in which the bucket lives.


        :return: The namespace_name of this CreateObjectStorageServiceActionDetails.
        :rtype: str
        """
        return self._namespace_name

    @namespace_name.setter
    def namespace_name(self, namespace_name):
        """
        Sets the namespace_name of this CreateObjectStorageServiceActionDetails.
        The Object Storage namespace in which the bucket lives.


        :param namespace_name: The namespace_name of this CreateObjectStorageServiceActionDetails.
        :type: str
        """
        self._namespace_name = namespace_name

    @property
    def bucket_name(self):
        """
        **[Required]** Gets the bucket_name of this CreateObjectStorageServiceActionDetails.
        The name of the bucket.

        Example: `my-new-bucket1`


        :return: The bucket_name of this CreateObjectStorageServiceActionDetails.
        :rtype: str
        """
        return self._bucket_name

    @bucket_name.setter
    def bucket_name(self, bucket_name):
        """
        Sets the bucket_name of this CreateObjectStorageServiceActionDetails.
        The name of the bucket.

        Example: `my-new-bucket1`


        :param bucket_name: The bucket_name of this CreateObjectStorageServiceActionDetails.
        :type: str
        """
        self._bucket_name = bucket_name

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
