# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.

from .action import Action
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ObjectStorageServiceAction(Action):
    """
    An action that delivers to an Oracle Object Storage bucket.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ObjectStorageServiceAction object with values from keyword arguments. The default value of the :py:attr:`~oci.events.models.ObjectStorageServiceAction.action_type` attribute
        of this class is ``OBJECTSTORAGE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param action_type:
            The value to assign to the action_type property of this ObjectStorageServiceAction.
            Allowed values for this property are: "ONS", "OSS", "FAAS", "OBJECTSTORAGE"
        :type action_type: str

        :param id:
            The value to assign to the id property of this ObjectStorageServiceAction.
        :type id: str

        :param lifecycle_message:
            The value to assign to the lifecycle_message property of this ObjectStorageServiceAction.
        :type lifecycle_message: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this ObjectStorageServiceAction.
            Allowed values for this property are: "CREATING", "ACTIVE", "INACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED"
        :type lifecycle_state: str

        :param description:
            The value to assign to the description property of this ObjectStorageServiceAction.
        :type description: str

        :param namespace_name:
            The value to assign to the namespace_name property of this ObjectStorageServiceAction.
        :type namespace_name: str

        :param bucket_name:
            The value to assign to the bucket_name property of this ObjectStorageServiceAction.
        :type bucket_name: str

        """
        self.swagger_types = {
            'action_type': 'str',
            'id': 'str',
            'lifecycle_message': 'str',
            'lifecycle_state': 'str',
            'description': 'str',
            'namespace_name': 'str',
            'bucket_name': 'str'
        }

        self.attribute_map = {
            'action_type': 'actionType',
            'id': 'id',
            'lifecycle_message': 'lifecycleMessage',
            'lifecycle_state': 'lifecycleState',
            'description': 'description',
            'namespace_name': 'namespaceName',
            'bucket_name': 'bucketName'
        }

        self._action_type = None
        self._id = None
        self._lifecycle_message = None
        self._lifecycle_state = None
        self._description = None
        self._namespace_name = None
        self._bucket_name = None
        self._action_type = 'OBJECTSTORAGE'

    @property
    def namespace_name(self):
        """
        Gets the namespace_name of this ObjectStorageServiceAction.
        The Object Storage namespace in which the bucket lives.


        :return: The namespace_name of this ObjectStorageServiceAction.
        :rtype: str
        """
        return self._namespace_name

    @namespace_name.setter
    def namespace_name(self, namespace_name):
        """
        Sets the namespace_name of this ObjectStorageServiceAction.
        The Object Storage namespace in which the bucket lives.


        :param namespace_name: The namespace_name of this ObjectStorageServiceAction.
        :type: str
        """
        self._namespace_name = namespace_name

    @property
    def bucket_name(self):
        """
        Gets the bucket_name of this ObjectStorageServiceAction.
        The name of the bucket.

        Example: `my-new-bucket1`


        :return: The bucket_name of this ObjectStorageServiceAction.
        :rtype: str
        """
        return self._bucket_name

    @bucket_name.setter
    def bucket_name(self, bucket_name):
        """
        Sets the bucket_name of this ObjectStorageServiceAction.
        The name of the bucket.

        Example: `my-new-bucket1`


        :param bucket_name: The bucket_name of this ObjectStorageServiceAction.
        :type: str
        """
        self._bucket_name = bucket_name

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
