# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Account(object):
    """
    The basic information for an account object.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new Account object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param tenancy_ocid:
            The value to assign to the tenancy_ocid property of this Account.
        :type tenancy_ocid: str

        :param account_name:
            The value to assign to the account_name property of this Account.
        :type account_name: str

        :param state:
            The value to assign to the state property of this Account.
        :type state: str

        :param home_region:
            The value to assign to the home_region property of this Account.
        :type home_region: str

        :param active_regions:
            The value to assign to the active_regions property of this Account.
        :type active_regions: list[str]

        """
        self.swagger_types = {
            'tenancy_ocid': 'str',
            'account_name': 'str',
            'state': 'str',
            'home_region': 'str',
            'active_regions': 'list[str]'
        }

        self.attribute_map = {
            'tenancy_ocid': 'tenancyOcid',
            'account_name': 'accountName',
            'state': 'state',
            'home_region': 'homeRegion',
            'active_regions': 'activeRegions'
        }

        self._tenancy_ocid = None
        self._account_name = None
        self._state = None
        self._home_region = None
        self._active_regions = None

    @property
    def tenancy_ocid(self):
        """
        Gets the tenancy_ocid of this Account.
        The OCID of the tenancy.


        :return: The tenancy_ocid of this Account.
        :rtype: str
        """
        return self._tenancy_ocid

    @tenancy_ocid.setter
    def tenancy_ocid(self, tenancy_ocid):
        """
        Sets the tenancy_ocid of this Account.
        The OCID of the tenancy.


        :param tenancy_ocid: The tenancy_ocid of this Account.
        :type: str
        """
        self._tenancy_ocid = tenancy_ocid

    @property
    def account_name(self):
        """
        **[Required]** Gets the account_name of this Account.
        The name of the tenant.


        :return: The account_name of this Account.
        :rtype: str
        """
        return self._account_name

    @account_name.setter
    def account_name(self, account_name):
        """
        Sets the account_name of this Account.
        The name of the tenant.


        :param account_name: The account_name of this Account.
        :type: str
        """
        self._account_name = account_name

    @property
    def state(self):
        """
        **[Required]** Gets the state of this Account.
        The lifecycle state of the tenant.


        :return: The state of this Account.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """
        Sets the state of this Account.
        The lifecycle state of the tenant.


        :param state: The state of this Account.
        :type: str
        """
        self._state = state

    @property
    def home_region(self):
        """
        **[Required]** Gets the home_region of this Account.
        The tenant home region.


        :return: The home_region of this Account.
        :rtype: str
        """
        return self._home_region

    @home_region.setter
    def home_region(self, home_region):
        """
        Sets the home_region of this Account.
        The tenant home region.


        :param home_region: The home_region of this Account.
        :type: str
        """
        self._home_region = home_region

    @property
    def active_regions(self):
        """
        **[Required]** Gets the active_regions of this Account.
        The tenant active regions.


        :return: The active_regions of this Account.
        :rtype: list[str]
        """
        return self._active_regions

    @active_regions.setter
    def active_regions(self, active_regions):
        """
        Sets the active_regions of this Account.
        The tenant active regions.


        :param active_regions: The active_regions of this Account.
        :type: list[str]
        """
        self._active_regions = active_regions

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
