# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.

from .identity_provider import IdentityProvider
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Saml2IdentityProvider(IdentityProvider):
    """
    A special type of :class:`IdentityProvider` that
    supports the SAML 2.0 protocol. For more information, see
    `Identity Providers and Federation`__.

    __ https://docs.cloud.oracle.com/Content/Identity/Concepts/federation.htm
    """

    def __init__(self, **kwargs):
        """
        Initializes a new Saml2IdentityProvider object with values from keyword arguments. The default value of the :py:attr:`~oci.identity.models.Saml2IdentityProvider.protocol` attribute
        of this class is ``SAML2`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this Saml2IdentityProvider.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this Saml2IdentityProvider.
        :type compartment_id: str

        :param name:
            The value to assign to the name property of this Saml2IdentityProvider.
        :type name: str

        :param description:
            The value to assign to the description property of this Saml2IdentityProvider.
        :type description: str

        :param product_type:
            The value to assign to the product_type property of this Saml2IdentityProvider.
        :type product_type: str

        :param time_created:
            The value to assign to the time_created property of this Saml2IdentityProvider.
        :type time_created: datetime

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this Saml2IdentityProvider.
            Allowed values for this property are: "CREATING", "ACTIVE", "INACTIVE", "DELETING", "DELETED"
        :type lifecycle_state: str

        :param inactive_status:
            The value to assign to the inactive_status property of this Saml2IdentityProvider.
        :type inactive_status: int

        :param protocol:
            The value to assign to the protocol property of this Saml2IdentityProvider.
        :type protocol: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this Saml2IdentityProvider.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this Saml2IdentityProvider.
        :type defined_tags: dict(str, dict(str, object))

        :param metadata_url:
            The value to assign to the metadata_url property of this Saml2IdentityProvider.
        :type metadata_url: str

        :param signing_certificate:
            The value to assign to the signing_certificate property of this Saml2IdentityProvider.
        :type signing_certificate: str

        :param redirect_url:
            The value to assign to the redirect_url property of this Saml2IdentityProvider.
        :type redirect_url: str

        :param freeform_attributes:
            The value to assign to the freeform_attributes property of this Saml2IdentityProvider.
        :type freeform_attributes: dict(str, str)

        :param encrypt_assertion:
            The value to assign to the encrypt_assertion property of this Saml2IdentityProvider.
        :type encrypt_assertion: bool

        :param force_authentication:
            The value to assign to the force_authentication property of this Saml2IdentityProvider.
        :type force_authentication: bool

        :param authn_context_class_refs:
            The value to assign to the authn_context_class_refs property of this Saml2IdentityProvider.
        :type authn_context_class_refs: list[str]

        :param status_message:
            The value to assign to the status_message property of this Saml2IdentityProvider.
        :type status_message: str

        """
        self.swagger_types = {
            'id': 'str',
            'compartment_id': 'str',
            'name': 'str',
            'description': 'str',
            'product_type': 'str',
            'time_created': 'datetime',
            'lifecycle_state': 'str',
            'inactive_status': 'int',
            'protocol': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'metadata_url': 'str',
            'signing_certificate': 'str',
            'redirect_url': 'str',
            'freeform_attributes': 'dict(str, str)',
            'encrypt_assertion': 'bool',
            'force_authentication': 'bool',
            'authn_context_class_refs': 'list[str]',
            'status_message': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'compartment_id': 'compartmentId',
            'name': 'name',
            'description': 'description',
            'product_type': 'productType',
            'time_created': 'timeCreated',
            'lifecycle_state': 'lifecycleState',
            'inactive_status': 'inactiveStatus',
            'protocol': 'protocol',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'metadata_url': 'metadataUrl',
            'signing_certificate': 'signingCertificate',
            'redirect_url': 'redirectUrl',
            'freeform_attributes': 'freeformAttributes',
            'encrypt_assertion': 'encryptAssertion',
            'force_authentication': 'forceAuthentication',
            'authn_context_class_refs': 'authnContextClassRefs',
            'status_message': 'statusMessage'
        }

        self._id = None
        self._compartment_id = None
        self._name = None
        self._description = None
        self._product_type = None
        self._time_created = None
        self._lifecycle_state = None
        self._inactive_status = None
        self._protocol = None
        self._freeform_tags = None
        self._defined_tags = None
        self._metadata_url = None
        self._signing_certificate = None
        self._redirect_url = None
        self._freeform_attributes = None
        self._encrypt_assertion = None
        self._force_authentication = None
        self._authn_context_class_refs = None
        self._status_message = None
        self._protocol = 'SAML2'

    @property
    def metadata_url(self):
        """
        **[Required]** Gets the metadata_url of this Saml2IdentityProvider.
        The URL for retrieving the identity provider's metadata, which
        contains information required for federating.


        :return: The metadata_url of this Saml2IdentityProvider.
        :rtype: str
        """
        return self._metadata_url

    @metadata_url.setter
    def metadata_url(self, metadata_url):
        """
        Sets the metadata_url of this Saml2IdentityProvider.
        The URL for retrieving the identity provider's metadata, which
        contains information required for federating.


        :param metadata_url: The metadata_url of this Saml2IdentityProvider.
        :type: str
        """
        self._metadata_url = metadata_url

    @property
    def signing_certificate(self):
        """
        **[Required]** Gets the signing_certificate of this Saml2IdentityProvider.
        The identity provider's signing certificate used by the IAM Service
        to validate the SAML2 token.


        :return: The signing_certificate of this Saml2IdentityProvider.
        :rtype: str
        """
        return self._signing_certificate

    @signing_certificate.setter
    def signing_certificate(self, signing_certificate):
        """
        Sets the signing_certificate of this Saml2IdentityProvider.
        The identity provider's signing certificate used by the IAM Service
        to validate the SAML2 token.


        :param signing_certificate: The signing_certificate of this Saml2IdentityProvider.
        :type: str
        """
        self._signing_certificate = signing_certificate

    @property
    def redirect_url(self):
        """
        **[Required]** Gets the redirect_url of this Saml2IdentityProvider.
        The URL to redirect federated users to for authentication with the
        identity provider.


        :return: The redirect_url of this Saml2IdentityProvider.
        :rtype: str
        """
        return self._redirect_url

    @redirect_url.setter
    def redirect_url(self, redirect_url):
        """
        Sets the redirect_url of this Saml2IdentityProvider.
        The URL to redirect federated users to for authentication with the
        identity provider.


        :param redirect_url: The redirect_url of this Saml2IdentityProvider.
        :type: str
        """
        self._redirect_url = redirect_url

    @property
    def freeform_attributes(self):
        """
        Gets the freeform_attributes of this Saml2IdentityProvider.
        Extra name value pairs associated with this identity provider.
        Example: `{\"clientId\": \"app_sf3kdjf3\"}`


        :return: The freeform_attributes of this Saml2IdentityProvider.
        :rtype: dict(str, str)
        """
        return self._freeform_attributes

    @freeform_attributes.setter
    def freeform_attributes(self, freeform_attributes):
        """
        Sets the freeform_attributes of this Saml2IdentityProvider.
        Extra name value pairs associated with this identity provider.
        Example: `{\"clientId\": \"app_sf3kdjf3\"}`


        :param freeform_attributes: The freeform_attributes of this Saml2IdentityProvider.
        :type: dict(str, str)
        """
        self._freeform_attributes = freeform_attributes

    @property
    def encrypt_assertion(self):
        """
        Gets the encrypt_assertion of this Saml2IdentityProvider.
        When set to true, the service provider expects the SAML assertion to be encrypted by the identity provider,
        using the service provider's encryption key. In this case, the service provider is Oracle Cloud
        Infrastructure Authentication service.


        :return: The encrypt_assertion of this Saml2IdentityProvider.
        :rtype: bool
        """
        return self._encrypt_assertion

    @encrypt_assertion.setter
    def encrypt_assertion(self, encrypt_assertion):
        """
        Sets the encrypt_assertion of this Saml2IdentityProvider.
        When set to true, the service provider expects the SAML assertion to be encrypted by the identity provider,
        using the service provider's encryption key. In this case, the service provider is Oracle Cloud
        Infrastructure Authentication service.


        :param encrypt_assertion: The encrypt_assertion of this Saml2IdentityProvider.
        :type: bool
        """
        self._encrypt_assertion = encrypt_assertion

    @property
    def force_authentication(self):
        """
        Gets the force_authentication of this Saml2IdentityProvider.
        If set to true, when the user is redirected to the identity provider, the identity provider forces the
        user to provide credentials and re-authenticate, even if there is an active login session.


        :return: The force_authentication of this Saml2IdentityProvider.
        :rtype: bool
        """
        return self._force_authentication

    @force_authentication.setter
    def force_authentication(self, force_authentication):
        """
        Sets the force_authentication of this Saml2IdentityProvider.
        If set to true, when the user is redirected to the identity provider, the identity provider forces the
        user to provide credentials and re-authenticate, even if there is an active login session.


        :param force_authentication: The force_authentication of this Saml2IdentityProvider.
        :type: bool
        """
        self._force_authentication = force_authentication

    @property
    def authn_context_class_refs(self):
        """
        Gets the authn_context_class_refs of this Saml2IdentityProvider.
        Authentication contexts requested when sending a SAML request to the identity provider. There could be one or
        more requested contexts. Usually identity provider uses the one that has the highest authentication strength.
        Example: `[\"urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport\",
        \"urn:oasis:names:tc:SAML:2.0:ac:classes:TLSClient\"]`


        :return: The authn_context_class_refs of this Saml2IdentityProvider.
        :rtype: list[str]
        """
        return self._authn_context_class_refs

    @authn_context_class_refs.setter
    def authn_context_class_refs(self, authn_context_class_refs):
        """
        Sets the authn_context_class_refs of this Saml2IdentityProvider.
        Authentication contexts requested when sending a SAML request to the identity provider. There could be one or
        more requested contexts. Usually identity provider uses the one that has the highest authentication strength.
        Example: `[\"urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport\",
        \"urn:oasis:names:tc:SAML:2.0:ac:classes:TLSClient\"]`


        :param authn_context_class_refs: The authn_context_class_refs of this Saml2IdentityProvider.
        :type: list[str]
        """
        self._authn_context_class_refs = authn_context_class_refs

    @property
    def status_message(self):
        """
        Gets the status_message of this Saml2IdentityProvider.
        A status message for this identity provider.
        Example: SAML metadata for this identity provider has expired.


        :return: The status_message of this Saml2IdentityProvider.
        :rtype: str
        """
        return self._status_message

    @status_message.setter
    def status_message(self, status_message):
        """
        Sets the status_message of this Saml2IdentityProvider.
        A status message for this identity provider.
        Example: SAML metadata for this identity provider has expired.


        :param status_message: The status_message of this Saml2IdentityProvider.
        :type: str
        """
        self._status_message = status_message

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
