# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.

from .update_identity_provider_details import UpdateIdentityProviderDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateSaml2IdentityProviderDetails(UpdateIdentityProviderDetails):
    """
    UpdateSaml2IdentityProviderDetails model.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateSaml2IdentityProviderDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.identity.models.UpdateSaml2IdentityProviderDetails.protocol` attribute
        of this class is ``SAML2`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param protocol:
            The value to assign to the protocol property of this UpdateSaml2IdentityProviderDetails.
            Allowed values for this property are: "SAML2"
        :type protocol: str

        :param description:
            The value to assign to the description property of this UpdateSaml2IdentityProviderDetails.
        :type description: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UpdateSaml2IdentityProviderDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this UpdateSaml2IdentityProviderDetails.
        :type defined_tags: dict(str, dict(str, object))

        :param metadata_url:
            The value to assign to the metadata_url property of this UpdateSaml2IdentityProviderDetails.
        :type metadata_url: str

        :param metadata:
            The value to assign to the metadata property of this UpdateSaml2IdentityProviderDetails.
        :type metadata: str

        :param freeform_attributes:
            The value to assign to the freeform_attributes property of this UpdateSaml2IdentityProviderDetails.
        :type freeform_attributes: dict(str, str)

        :param encrypt_assertion:
            The value to assign to the encrypt_assertion property of this UpdateSaml2IdentityProviderDetails.
        :type encrypt_assertion: bool

        :param force_authentication:
            The value to assign to the force_authentication property of this UpdateSaml2IdentityProviderDetails.
        :type force_authentication: bool

        :param authn_context_class_refs:
            The value to assign to the authn_context_class_refs property of this UpdateSaml2IdentityProviderDetails.
        :type authn_context_class_refs: list[str]

        """
        self.swagger_types = {
            'protocol': 'str',
            'description': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'metadata_url': 'str',
            'metadata': 'str',
            'freeform_attributes': 'dict(str, str)',
            'encrypt_assertion': 'bool',
            'force_authentication': 'bool',
            'authn_context_class_refs': 'list[str]'
        }

        self.attribute_map = {
            'protocol': 'protocol',
            'description': 'description',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'metadata_url': 'metadataUrl',
            'metadata': 'metadata',
            'freeform_attributes': 'freeformAttributes',
            'encrypt_assertion': 'encryptAssertion',
            'force_authentication': 'forceAuthentication',
            'authn_context_class_refs': 'authnContextClassRefs'
        }

        self._protocol = None
        self._description = None
        self._freeform_tags = None
        self._defined_tags = None
        self._metadata_url = None
        self._metadata = None
        self._freeform_attributes = None
        self._encrypt_assertion = None
        self._force_authentication = None
        self._authn_context_class_refs = None
        self._protocol = 'SAML2'

    @property
    def metadata_url(self):
        """
        Gets the metadata_url of this UpdateSaml2IdentityProviderDetails.
        The URL for retrieving the identity provider's metadata,
        which contains information required for federating.


        :return: The metadata_url of this UpdateSaml2IdentityProviderDetails.
        :rtype: str
        """
        return self._metadata_url

    @metadata_url.setter
    def metadata_url(self, metadata_url):
        """
        Sets the metadata_url of this UpdateSaml2IdentityProviderDetails.
        The URL for retrieving the identity provider's metadata,
        which contains information required for federating.


        :param metadata_url: The metadata_url of this UpdateSaml2IdentityProviderDetails.
        :type: str
        """
        self._metadata_url = metadata_url

    @property
    def metadata(self):
        """
        Gets the metadata of this UpdateSaml2IdentityProviderDetails.
        The XML that contains the information required for federating.


        :return: The metadata of this UpdateSaml2IdentityProviderDetails.
        :rtype: str
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata):
        """
        Sets the metadata of this UpdateSaml2IdentityProviderDetails.
        The XML that contains the information required for federating.


        :param metadata: The metadata of this UpdateSaml2IdentityProviderDetails.
        :type: str
        """
        self._metadata = metadata

    @property
    def freeform_attributes(self):
        """
        Gets the freeform_attributes of this UpdateSaml2IdentityProviderDetails.
        Extra name value pairs associated with this identity provider.
        Example: `{\"clientId\": \"app_sf3kdjf3\"}`


        :return: The freeform_attributes of this UpdateSaml2IdentityProviderDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_attributes

    @freeform_attributes.setter
    def freeform_attributes(self, freeform_attributes):
        """
        Sets the freeform_attributes of this UpdateSaml2IdentityProviderDetails.
        Extra name value pairs associated with this identity provider.
        Example: `{\"clientId\": \"app_sf3kdjf3\"}`


        :param freeform_attributes: The freeform_attributes of this UpdateSaml2IdentityProviderDetails.
        :type: dict(str, str)
        """
        self._freeform_attributes = freeform_attributes

    @property
    def encrypt_assertion(self):
        """
        Gets the encrypt_assertion of this UpdateSaml2IdentityProviderDetails.
        When set to true, the service provider expects the SAML assertion to be encrypted by the identity provider,
        using the service provider's encryption key. In this case, the service provider is Oracle Cloud
        Infrastructure Authentication service.


        :return: The encrypt_assertion of this UpdateSaml2IdentityProviderDetails.
        :rtype: bool
        """
        return self._encrypt_assertion

    @encrypt_assertion.setter
    def encrypt_assertion(self, encrypt_assertion):
        """
        Sets the encrypt_assertion of this UpdateSaml2IdentityProviderDetails.
        When set to true, the service provider expects the SAML assertion to be encrypted by the identity provider,
        using the service provider's encryption key. In this case, the service provider is Oracle Cloud
        Infrastructure Authentication service.


        :param encrypt_assertion: The encrypt_assertion of this UpdateSaml2IdentityProviderDetails.
        :type: bool
        """
        self._encrypt_assertion = encrypt_assertion

    @property
    def force_authentication(self):
        """
        Gets the force_authentication of this UpdateSaml2IdentityProviderDetails.
        If set to true, when the user is redirected to the identity provider, the identity provider forces the
        user to provide credentials and re-authenticate, even if there is an active login session.


        :return: The force_authentication of this UpdateSaml2IdentityProviderDetails.
        :rtype: bool
        """
        return self._force_authentication

    @force_authentication.setter
    def force_authentication(self, force_authentication):
        """
        Sets the force_authentication of this UpdateSaml2IdentityProviderDetails.
        If set to true, when the user is redirected to the identity provider, the identity provider forces the
        user to provide credentials and re-authenticate, even if there is an active login session.


        :param force_authentication: The force_authentication of this UpdateSaml2IdentityProviderDetails.
        :type: bool
        """
        self._force_authentication = force_authentication

    @property
    def authn_context_class_refs(self):
        """
        Gets the authn_context_class_refs of this UpdateSaml2IdentityProviderDetails.
        Authentication contexts requested when sending a SAML request to the identity provider. There could be one or
        more requested contexts. Usually identity provider uses the one that has the highest authentication strength.
        Example: `[\"urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport\",
        \"urn:oasis:names:tc:SAML:2.0:ac:classes:TLSClient\"]`


        :return: The authn_context_class_refs of this UpdateSaml2IdentityProviderDetails.
        :rtype: list[str]
        """
        return self._authn_context_class_refs

    @authn_context_class_refs.setter
    def authn_context_class_refs(self, authn_context_class_refs):
        """
        Sets the authn_context_class_refs of this UpdateSaml2IdentityProviderDetails.
        Authentication contexts requested when sending a SAML request to the identity provider. There could be one or
        more requested contexts. Usually identity provider uses the one that has the highest authentication strength.
        Example: `[\"urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport\",
        \"urn:oasis:names:tc:SAML:2.0:ac:classes:TLSClient\"]`


        :param authn_context_class_refs: The authn_context_class_refs of this UpdateSaml2IdentityProviderDetails.
        :type: list[str]
        """
        self._authn_context_class_refs = authn_context_class_refs

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
