# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateTagRuleDetails(object):
    """
    UpdateTagRuleDetails model.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateTagRuleDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param description:
            The value to assign to the description property of this UpdateTagRuleDetails.
        :type description: str

        :param rule_text:
            The value to assign to the rule_text property of this UpdateTagRuleDetails.
        :type rule_text: str

        :param is_disabled:
            The value to assign to the is_disabled property of this UpdateTagRuleDetails.
        :type is_disabled: bool

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UpdateTagRuleDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this UpdateTagRuleDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'description': 'str',
            'rule_text': 'str',
            'is_disabled': 'bool',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }

        self.attribute_map = {
            'description': 'description',
            'rule_text': 'ruleText',
            'is_disabled': 'isDisabled',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }

        self._description = None
        self._rule_text = None
        self._is_disabled = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def description(self):
        """
        Gets the description of this UpdateTagRuleDetails.
        The description you assign to the tag rule. Does not have to be unique, and it's changeable.


        :return: The description of this UpdateTagRuleDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this UpdateTagRuleDetails.
        The description you assign to the tag rule. Does not have to be unique, and it's changeable.


        :param description: The description of this UpdateTagRuleDetails.
        :type: str
        """
        self._description = description

    @property
    def rule_text(self):
        """
        Gets the rule_text of this UpdateTagRuleDetails.
        A statement that is written in the tag rule language.


        :return: The rule_text of this UpdateTagRuleDetails.
        :rtype: str
        """
        return self._rule_text

    @rule_text.setter
    def rule_text(self, rule_text):
        """
        Sets the rule_text of this UpdateTagRuleDetails.
        A statement that is written in the tag rule language.


        :param rule_text: The rule_text of this UpdateTagRuleDetails.
        :type: str
        """
        self._rule_text = rule_text

    @property
    def is_disabled(self):
        """
        Gets the is_disabled of this UpdateTagRuleDetails.
        whether or not the tag rule is disabled. If this is not specified, the rule state won't change.


        :return: The is_disabled of this UpdateTagRuleDetails.
        :rtype: bool
        """
        return self._is_disabled

    @is_disabled.setter
    def is_disabled(self, is_disabled):
        """
        Sets the is_disabled of this UpdateTagRuleDetails.
        whether or not the tag rule is disabled. If this is not specified, the rule state won't change.


        :param is_disabled: The is_disabled of this UpdateTagRuleDetails.
        :type: bool
        """
        self._is_disabled = is_disabled

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this UpdateTagRuleDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this UpdateTagRuleDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this UpdateTagRuleDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this UpdateTagRuleDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this UpdateTagRuleDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this UpdateTagRuleDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this UpdateTagRuleDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this UpdateTagRuleDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
