# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.

from __future__ import absolute_import

from .create_kam_release_details import CreateKamReleaseDetails
from .kam_chart_summary import KamChartSummary
from .kam_override import KamOverride
from .kam_release import KamRelease
from .kam_release_summary import KamReleaseSummary
from .update_kam_release_details import UpdateKamReleaseDetails
from .work_request import WorkRequest
from .work_request_error import WorkRequestError
from .work_request_log_entry import WorkRequestLogEntry
from .work_request_resource import WorkRequestResource
from .work_request_summary import WorkRequestSummary

# Maps type names to classes for kam services.
kam_type_mapping = {
    "CreateKamReleaseDetails": CreateKamReleaseDetails,
    "KamChartSummary": KamChartSummary,
    "KamOverride": KamOverride,
    "KamRelease": KamRelease,
    "KamReleaseSummary": KamReleaseSummary,
    "UpdateKamReleaseDetails": UpdateKamReleaseDetails,
    "WorkRequest": WorkRequest,
    "WorkRequestError": WorkRequestError,
    "WorkRequestLogEntry": WorkRequestLogEntry,
    "WorkRequestResource": WorkRequestResource,
    "WorkRequestSummary": WorkRequestSummary
}
