# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateKamReleaseDetails(object):
    """
    Details of the installation request. The KAM chart OCID can be looked up
    using the ListKamCharts API
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateKamReleaseDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param kam_chart_id:
            The value to assign to the kam_chart_id property of this CreateKamReleaseDetails.
        :type kam_chart_id: str

        :param overrides:
            The value to assign to the overrides property of this CreateKamReleaseDetails.
        :type overrides: list[KamOverride]

        :param namespace:
            The value to assign to the namespace property of this CreateKamReleaseDetails.
        :type namespace: str

        :param release_name:
            The value to assign to the release_name property of this CreateKamReleaseDetails.
        :type release_name: str

        """
        self.swagger_types = {
            'kam_chart_id': 'str',
            'overrides': 'list[KamOverride]',
            'namespace': 'str',
            'release_name': 'str'
        }

        self.attribute_map = {
            'kam_chart_id': 'kamChartId',
            'overrides': 'overrides',
            'namespace': 'namespace',
            'release_name': 'releaseName'
        }

        self._kam_chart_id = None
        self._overrides = None
        self._namespace = None
        self._release_name = None

    @property
    def kam_chart_id(self):
        """
        **[Required]** Gets the kam_chart_id of this CreateKamReleaseDetails.
        The OCID of the OKE Add-on or Marketplace app to deploy


        :return: The kam_chart_id of this CreateKamReleaseDetails.
        :rtype: str
        """
        return self._kam_chart_id

    @kam_chart_id.setter
    def kam_chart_id(self, kam_chart_id):
        """
        Sets the kam_chart_id of this CreateKamReleaseDetails.
        The OCID of the OKE Add-on or Marketplace app to deploy


        :param kam_chart_id: The kam_chart_id of this CreateKamReleaseDetails.
        :type: str
        """
        self._kam_chart_id = kam_chart_id

    @property
    def overrides(self):
        """
        Gets the overrides of this CreateKamReleaseDetails.
        List of overrides for default configuration


        :return: The overrides of this CreateKamReleaseDetails.
        :rtype: list[KamOverride]
        """
        return self._overrides

    @overrides.setter
    def overrides(self, overrides):
        """
        Sets the overrides of this CreateKamReleaseDetails.
        List of overrides for default configuration


        :param overrides: The overrides of this CreateKamReleaseDetails.
        :type: list[KamOverride]
        """
        self._overrides = overrides

    @property
    def namespace(self):
        """
        Gets the namespace of this CreateKamReleaseDetails.
        Namespace to install to (optional)


        :return: The namespace of this CreateKamReleaseDetails.
        :rtype: str
        """
        return self._namespace

    @namespace.setter
    def namespace(self, namespace):
        """
        Sets the namespace of this CreateKamReleaseDetails.
        Namespace to install to (optional)


        :param namespace: The namespace of this CreateKamReleaseDetails.
        :type: str
        """
        self._namespace = namespace

    @property
    def release_name(self):
        """
        Gets the release_name of this CreateKamReleaseDetails.
        Release name to install (optional)


        :return: The release_name of this CreateKamReleaseDetails.
        :rtype: str
        """
        return self._release_name

    @release_name.setter
    def release_name(self, release_name):
        """
        Sets the release_name of this CreateKamReleaseDetails.
        Release name to install (optional)


        :param release_name: The release_name of this CreateKamReleaseDetails.
        :type: str
        """
        self._release_name = release_name

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
