# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class KamChartSummary(object):
    """
    An OKE Add-on or Marketplace application, the OCID of this record may be
    used for installation or upgrade
    """

    #: A constant which can be used with the package_type property of a KamChartSummary.
    #: This constant has a value of "OKE_ADDON"
    PACKAGE_TYPE_OKE_ADDON = "OKE_ADDON"

    #: A constant which can be used with the package_type property of a KamChartSummary.
    #: This constant has a value of "APPLICATION"
    PACKAGE_TYPE_APPLICATION = "APPLICATION"

    def __init__(self, **kwargs):
        """
        Initializes a new KamChartSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this KamChartSummary.
        :type id: str

        :param package_name:
            The value to assign to the package_name property of this KamChartSummary.
        :type package_name: str

        :param package_description:
            The value to assign to the package_description property of this KamChartSummary.
        :type package_description: str

        :param package_type:
            The value to assign to the package_type property of this KamChartSummary.
            Allowed values for this property are: "OKE_ADDON", "APPLICATION", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type package_type: str

        :param version:
            The value to assign to the version property of this KamChartSummary.
        :type version: str

        """
        self.swagger_types = {
            'id': 'str',
            'package_name': 'str',
            'package_description': 'str',
            'package_type': 'str',
            'version': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'package_name': 'packageName',
            'package_description': 'packageDescription',
            'package_type': 'packageType',
            'version': 'version'
        }

        self._id = None
        self._package_name = None
        self._package_description = None
        self._package_type = None
        self._version = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this KamChartSummary.
        The OCID of the kam chart.


        :return: The id of this KamChartSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this KamChartSummary.
        The OCID of the kam chart.


        :param id: The id of this KamChartSummary.
        :type: str
        """
        self._id = id

    @property
    def package_name(self):
        """
        Gets the package_name of this KamChartSummary.
        The name of the OKE Add-on or Marketplace app


        :return: The package_name of this KamChartSummary.
        :rtype: str
        """
        return self._package_name

    @package_name.setter
    def package_name(self, package_name):
        """
        Sets the package_name of this KamChartSummary.
        The name of the OKE Add-on or Marketplace app


        :param package_name: The package_name of this KamChartSummary.
        :type: str
        """
        self._package_name = package_name

    @property
    def package_description(self):
        """
        Gets the package_description of this KamChartSummary.
        The description of the package


        :return: The package_description of this KamChartSummary.
        :rtype: str
        """
        return self._package_description

    @package_description.setter
    def package_description(self, package_description):
        """
        Sets the package_description of this KamChartSummary.
        The description of the package


        :param package_description: The package_description of this KamChartSummary.
        :type: str
        """
        self._package_description = package_description

    @property
    def package_type(self):
        """
        Gets the package_type of this KamChartSummary.
        The type of package, like OKE Add-on or Marketplace application

        Allowed values for this property are: "OKE_ADDON", "APPLICATION", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The package_type of this KamChartSummary.
        :rtype: str
        """
        return self._package_type

    @package_type.setter
    def package_type(self, package_type):
        """
        Sets the package_type of this KamChartSummary.
        The type of package, like OKE Add-on or Marketplace application


        :param package_type: The package_type of this KamChartSummary.
        :type: str
        """
        allowed_values = ["OKE_ADDON", "APPLICATION"]
        if not value_allowed_none_or_none_sentinel(package_type, allowed_values):
            package_type = 'UNKNOWN_ENUM_VALUE'
        self._package_type = package_type

    @property
    def version(self):
        """
        Gets the version of this KamChartSummary.
        The version of the OKE Add-on or Marketplace app


        :return: The version of this KamChartSummary.
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """
        Sets the version of this KamChartSummary.
        The version of the OKE Add-on or Marketplace app


        :param version: The version of this KamChartSummary.
        :type: str
        """
        self._version = version

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
