# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class KamOverride(object):
    """
    KAM charts come with default configuration values. This may be used to
    override the defaults for the KAM chart
    """

    def __init__(self, **kwargs):
        """
        Initializes a new KamOverride object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this KamOverride.
        :type name: str

        :param value:
            The value to assign to the value property of this KamOverride.
        :type value: str

        """
        self.swagger_types = {
            'name': 'str',
            'value': 'str'
        }

        self.attribute_map = {
            'name': 'name',
            'value': 'value'
        }

        self._name = None
        self._value = None

    @property
    def name(self):
        """
        Gets the name of this KamOverride.
        KAM chart property to override


        :return: The name of this KamOverride.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this KamOverride.
        KAM chart property to override


        :param name: The name of this KamOverride.
        :type: str
        """
        self._name = name

    @property
    def value(self):
        """
        Gets the value of this KamOverride.
        KAM chart property value to override


        :return: The value of this KamOverride.
        :rtype: str
        """
        return self._value

    @value.setter
    def value(self, value):
        """
        Sets the value of this KamOverride.
        KAM chart property value to override


        :param value: The value of this KamOverride.
        :type: str
        """
        self._value = value

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
