# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class KamRelease(object):
    """
    KAM Release
    """

    #: A constant which can be used with the package_type property of a KamRelease.
    #: This constant has a value of "OKE_ADDON"
    PACKAGE_TYPE_OKE_ADDON = "OKE_ADDON"

    #: A constant which can be used with the package_type property of a KamRelease.
    #: This constant has a value of "APPLICATION"
    PACKAGE_TYPE_APPLICATION = "APPLICATION"

    #: A constant which can be used with the lifecycle_state property of a KamRelease.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a KamRelease.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a KamRelease.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a KamRelease.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a KamRelease.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a KamRelease.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    def __init__(self, **kwargs):
        """
        Initializes a new KamRelease object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this KamRelease.
        :type id: str

        :param kam_chart_id:
            The value to assign to the kam_chart_id property of this KamRelease.
        :type kam_chart_id: str

        :param package_name:
            The value to assign to the package_name property of this KamRelease.
        :type package_name: str

        :param package_type:
            The value to assign to the package_type property of this KamRelease.
            Allowed values for this property are: "OKE_ADDON", "APPLICATION"
        :type package_type: str

        :param package_version:
            The value to assign to the package_version property of this KamRelease.
        :type package_version: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this KamRelease.
            Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this KamRelease.
        :type lifecycle_details: str

        :param time_created:
            The value to assign to the time_created property of this KamRelease.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this KamRelease.
        :type time_updated: datetime

        :param freeform_tags:
            The value to assign to the freeform_tags property of this KamRelease.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this KamRelease.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'kam_chart_id': 'str',
            'package_name': 'str',
            'package_type': 'str',
            'package_version': 'str',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }

        self.attribute_map = {
            'id': 'id',
            'kam_chart_id': 'kamChartId',
            'package_name': 'packageName',
            'package_type': 'packageType',
            'package_version': 'packageVersion',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }

        self._id = None
        self._kam_chart_id = None
        self._package_name = None
        self._package_type = None
        self._package_version = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._time_created = None
        self._time_updated = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def id(self):
        """
        Gets the id of this KamRelease.
        The OCID of the kam release.


        :return: The id of this KamRelease.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this KamRelease.
        The OCID of the kam release.


        :param id: The id of this KamRelease.
        :type: str
        """
        self._id = id

    @property
    def kam_chart_id(self):
        """
        Gets the kam_chart_id of this KamRelease.
        The OCID of the kam chart


        :return: The kam_chart_id of this KamRelease.
        :rtype: str
        """
        return self._kam_chart_id

    @kam_chart_id.setter
    def kam_chart_id(self, kam_chart_id):
        """
        Sets the kam_chart_id of this KamRelease.
        The OCID of the kam chart


        :param kam_chart_id: The kam_chart_id of this KamRelease.
        :type: str
        """
        self._kam_chart_id = kam_chart_id

    @property
    def package_name(self):
        """
        Gets the package_name of this KamRelease.
        The name of the package


        :return: The package_name of this KamRelease.
        :rtype: str
        """
        return self._package_name

    @package_name.setter
    def package_name(self, package_name):
        """
        Sets the package_name of this KamRelease.
        The name of the package


        :param package_name: The package_name of this KamRelease.
        :type: str
        """
        self._package_name = package_name

    @property
    def package_type(self):
        """
        Gets the package_type of this KamRelease.
        The type of package, like OKE Add-on or Marketplace application

        Allowed values for this property are: "OKE_ADDON", "APPLICATION"


        :return: The package_type of this KamRelease.
        :rtype: str
        """
        return self._package_type

    @package_type.setter
    def package_type(self, package_type):
        """
        Sets the package_type of this KamRelease.
        The type of package, like OKE Add-on or Marketplace application


        :param package_type: The package_type of this KamRelease.
        :type: str
        """
        allowed_values = ["OKE_ADDON", "APPLICATION"]
        if not value_allowed_none_or_none_sentinel(package_type, allowed_values):
            raise ValueError(
                "Invalid value for `package_type`, must be None or one of {0}"
                .format(allowed_values)
            )
        self._package_type = package_type

    @property
    def package_version(self):
        """
        Gets the package_version of this KamRelease.
        The version of the package


        :return: The package_version of this KamRelease.
        :rtype: str
        """
        return self._package_version

    @package_version.setter
    def package_version(self, package_version):
        """
        Sets the package_version of this KamRelease.
        The version of the package


        :param package_version: The package_version of this KamRelease.
        :type: str
        """
        self._package_version = package_version

    @property
    def lifecycle_state(self):
        """
        Gets the lifecycle_state of this KamRelease.
        The current state of the release.

        Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"


        :return: The lifecycle_state of this KamRelease.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this KamRelease.
        The current state of the release.


        :param lifecycle_state: The lifecycle_state of this KamRelease.
        :type: str
        """
        allowed_values = ["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            raise ValueError(
                "Invalid value for `lifecycle_state`, must be None or one of {0}"
                .format(allowed_values)
            )
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this KamRelease.
        A message describing the current state in more detail.


        :return: The lifecycle_details of this KamRelease.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this KamRelease.
        A message describing the current state in more detail.


        :param lifecycle_details: The lifecycle_details of this KamRelease.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def time_created(self):
        """
        Gets the time_created of this KamRelease.
        The time the the release was created. An RFC3339 formatted datetime string


        :return: The time_created of this KamRelease.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this KamRelease.
        The time the the release was created. An RFC3339 formatted datetime string


        :param time_created: The time_created of this KamRelease.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this KamRelease.
        The time the release was updated. An RFC3339 formatted datetime string


        :return: The time_updated of this KamRelease.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this KamRelease.
        The time the release was updated. An RFC3339 formatted datetime string


        :param time_updated: The time_updated of this KamRelease.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this KamRelease.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this KamRelease.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this KamRelease.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this KamRelease.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this KamRelease.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this KamRelease.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this KamRelease.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this KamRelease.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
